/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VirtualFile;
import org.teiid.jboss.TeiidAttachments;

class VDBStructureDeployer
implements DeploymentUnitProcessor {
    private static final String VDB_EXTENSION = ".vdb";
    private static final String DYNAMIC_VDB_STRUCTURE = "-vdb.xml";
    private static final String DDL_VDB_STRUCTURE = "-vdb.ddl";

    VDBStructureDeployer() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        VirtualFile file = ((ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        if (file == null) {
            return;
        }
        if (deploymentName.toLowerCase().endsWith(VDB_EXTENSION)) {
            VirtualFile metainf = file.getChild("META-INF");
            if (metainf == null) {
                return;
            }
            if (metainf.getChild("vdb.xml") == null) {
                return;
            }
            TeiidAttachments.setAsVDBDeployment(deploymentUnit);
        } else if (deploymentName.toLowerCase().endsWith(DYNAMIC_VDB_STRUCTURE)) {
            TeiidAttachments.setAsVDBXMLDeployment(deploymentUnit);
        } else if (deploymentName.toLowerCase().endsWith(DDL_VDB_STRUCTURE)) {
            TeiidAttachments.setAsVDBDDLDeployment(deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

