/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */
package org.teiid.jboss;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.common.buffer.BufferManager;
import org.teiid.deployers.VDBRepository;
import org.teiid.query.ObjectReplicator;

class VDBRepositoryService implements Service<VDBRepository> {
	private VDBRepository repo;
    protected final InjectedValue<BufferManager> bufferManagerInjector = new InjectedValue<BufferManager>();
    protected final InjectedValue<ObjectReplicator> objectReplicatorInjector = new InjectedValue<ObjectReplicator>();
	
	public VDBRepositoryService(VDBRepository repo) {
		this.repo = repo;
	}
	
	@Override
	public void start(StartContext context) throws StartException {
	    repo.setBufferManager(this.bufferManagerInjector.getValue());
	    repo.setObjectReplicator(this.objectReplicatorInjector.getValue());
		repo.start();
	}

	@Override
	public void stop(StopContext context) {
	}

	@Override
	public VDBRepository getValue() throws IllegalStateException, IllegalArgumentException {
		return repo;
	}
}
