/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Condition;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageUtil;
import org.teiid.language.Select;

public class TestLanguageUtil
extends TestCase {
    public TestLanguageUtil(String name) {
        super(name);
    }

    private Condition convertCriteria(String criteriaStr) {
        TranslationUtility util = FakeTranslationFactory.getInstance().getBQTTranslationUtility();
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE " + criteriaStr;
        Select query = (Select)util.parseCommand(sql);
        Condition criteria = query.getWhere();
        return criteria;
    }

    public void helpTestSeparateByAnd(String criteriaStr, String[] expected) throws Exception {
        Condition criteria = this.convertCriteria(criteriaStr);
        List crits = LanguageUtil.separateCriteriaByAnd((Condition)criteria);
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList(expected));
        HashSet<String> actualSet = new HashSet<String>();
        for (int i = 0; i < crits.size(); ++i) {
            actualSet.add(((Condition)crits.get(i)).toString());
        }
        TestLanguageUtil.assertEquals((String)"Did not get expected criteria pieces", expectedSet, actualSet);
    }

    public void testSeparateCrit_predicate() throws Exception {
        this.helpTestSeparateByAnd("intkey = 1", new String[]{"SmallA.IntKey = 1"});
    }

    public void testSeparateCrit_ORisConjunct() throws Exception {
        this.helpTestSeparateByAnd("intkey = 1 OR intkey = 2", new String[]{"SmallA.IntKey = 1 OR SmallA.IntKey = 2"});
    }

    public void testSeparateCrit_nestedAND() throws Exception {
        this.helpTestSeparateByAnd("((intkey = 1 AND intnum = 2) AND (stringnum = '3') AND (stringkey = '4'))", new String[]{"SmallA.IntKey = 1", "SmallA.IntNum = 2", "SmallA.StringNum = '3'", "SmallA.StringKey = '4'"});
    }

    public void testSeparateCrit_NOT() throws Exception {
        this.helpTestSeparateByAnd("(NOT (intkey = 1 AND intnum = 2) AND (stringnum = '3') AND (stringkey = '4'))", new String[]{"SmallA.IntKey <> 1 OR SmallA.IntNum <> 2", "SmallA.StringNum = '3'", "SmallA.StringKey = '4'"});
    }

    public void helpTestCombineCriteria(String primaryStr, String additionalStr, String expected) throws Exception {
        Condition primaryCrit = primaryStr == null ? null : this.convertCriteria(primaryStr);
        Condition additionalCrit = additionalStr == null ? null : this.convertCriteria(additionalStr);
        Condition crit = LanguageUtil.combineCriteria((Condition)primaryCrit, (Condition)additionalCrit, (LanguageFactory)LanguageFactory.INSTANCE);
        String critStr = crit == null ? null : crit.toString();
        TestLanguageUtil.assertEquals((String)"Did not get expected criteria", (String)expected, (String)critStr);
    }

    public void testCombineCrit_bothNull() throws Exception {
        this.helpTestCombineCriteria(null, null, null);
    }

    public void testCombineCrit_primaryNull() throws Exception {
        this.helpTestCombineCriteria(null, "intkey = 1", "SmallA.IntKey = 1");
    }

    public void testCombineCrit_additionalNull() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", null, "SmallA.IntKey = 1");
    }

    public void testCombineCrit_bothPredicates() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", "intkey = 2", "SmallA.IntKey = 1 AND SmallA.IntKey = 2");
    }

    public void testCombineCrit_primaryPredicate() throws Exception {
        this.helpTestCombineCriteria("intkey = 1", "intnum = 2 AND stringkey = '3'", "SmallA.IntKey = 1 AND SmallA.IntNum = 2 AND SmallA.StringKey = '3'");
    }

    public void testCombineCrit_additionalPredicate() throws Exception {
        this.helpTestCombineCriteria("intkey = 1 AND intnum = 2", "stringkey = '3'", "SmallA.IntKey = 1 AND SmallA.IntNum = 2 AND SmallA.StringKey = '3'");
    }
}

