/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.TransformationMetadata;

public class TestMatViews {
    private static final String MATVIEWS = "matviews";
    private Connection conn;
    private FakeServer server;

    @Before
    public void setUp() throws Exception {
        this.server = new FakeServer();
        this.server.deployVDB(MATVIEWS, UnitTestUtil.getTestDataPath() + "/matviews.vdb");
        this.conn = this.server.createConnection("jdbc:teiid:matviews");
    }

    @Test
    public void testSystemMatViewsWithImplicitLoad() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from MatViews order by name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.ERRORVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.MATVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        Assert.assertEquals((Object)"#MAT_TEST.RANDOMVIEW", (Object)rs.getString("targetName"));
        rs = s.executeQuery("select * from MatView");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        try {
            s.executeQuery("select * from ErrorView");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs = s.executeQuery("select * from MatViews where name = 'ErrorView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FAILED_LOAD", (Object)rs.getString("loadstate"));
    }

    @Test
    public void testSystemMatViewsWithExplicitRefresh() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('TEST.NotMat', false)");
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView1() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('foo', false)");
    }

    @Test
    public void testSystemMatViewsWithRowRefresh() throws Exception {
        VDBMetaData vdb = this.server.getVDB(MATVIEWS);
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        Table t = tm.getGroupID("TEST.RANDOMVIEW");
        t.setSelectTransformation("/*+ cache(updatable) */ " + t.getSelectTransformation());
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', 0)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from TEST.RANDOMVIEW");
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsWithRowRefreshNoPk() throws Exception {
        Statement s = this.conn.createStatement();
        s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        s.executeQuery("select * from (call refreshMatViewRow('TEST.MATVIEW', 0)) p");
    }
}

