/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestODBCSchema
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";

    public TestODBCSchema() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    @Test
    public void test_PG_AM() throws Exception {
        this.execute("select * FROM pg_am");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_ATTRDEF() throws Exception {
        this.execute("select * FROM pg_attrdef");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_ATTRIBUTE() throws Exception {
        this.execute("select * FROM pg_attribute");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_CLASS() throws Exception {
        this.execute("select * FROM pg_class");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_INDEX() throws Exception {
        this.execute("select * FROM pg_index");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_NAMESPACE() throws Exception {
        this.execute("select * FROM pg_namespace");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_TRIGGER() throws Exception {
        this.execute("select * FROM pg_trigger");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_TYPE() throws Exception {
        this.execute("select * FROM pg_type");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_DATABASE() throws Exception {
        this.execute("select* FROM pg_database");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_PG_USER() throws Exception {
        this.execute("select * FROM pg_user");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void testOIDUniquness() throws Exception {
        for (String table : new String[]{"Tables", "Columns", "Schemas", "DataTypes", "Keys", "Procedures", "ProcedureParams", "Properties"}) {
            this.execute("select count(distinct oid), count(*) from SYS." + table);
            this.internalResultSet.next();
            Assert.assertEquals((long)this.internalResultSet.getInt(2), (long)this.internalResultSet.getInt(1));
        }
    }
}

