/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TestMMDatabaseMetaData;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TestJDBCSocketTransport {
    static InetSocketAddress addr;
    static SocketListener jdbcTransport;
    Connection conn;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        FakeServer server = new FakeServer();
        server.setUseCallingThread(false);
        server.deployVDB("parts", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        jdbcTransport = new SocketListener(config, (ClientServiceRegistryImpl)server, (StorageManager)BufferManagerFactory.getStandaloneBufferManager(), 0);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (jdbcTransport != null) {
            jdbcTransport.stop();
        }
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        this.conn = TeiidDriver.getInstance().connect("jdbc:teiid:parts@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
    }

    @After
    public void tearDown() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test
    public void testSelect() throws Exception {
        Statement s = this.conn.createStatement();
        Assert.assertTrue((boolean)s.execute("select * from tables order by name"));
        TestMMDatabaseMetaData.compareResultSet(s.getResultSet());
    }
}

