/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.deployers.spi.DeploymentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.services.BufferServiceImpl;
import org.teiid.services.SessionServiceImpl;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;

public class FakeServer
extends ClientServiceRegistryImpl
implements ConnectionProfile {
    SessionServiceImpl sessionService = new SessionServiceImpl();
    LogonImpl logon;
    DQPCore dqp = new DQPCore();
    VDBRepository repo = new VDBRepository();
    private ConnectorManagerRepository cmr;
    private boolean useCallingThread = true;
    private ObjectReplicator replicator;

    public FakeServer() {
        this(new DQPConfiguration());
    }

    public void setReplicator(ObjectReplicator replicator) {
        this.replicator = replicator;
    }

    public FakeServer(DQPConfiguration config) {
        this(config, false);
    }

    public FakeServer(DQPConfiguration config, boolean realBufferMangaer) {
        this.logon = new LogonImpl((SessionService)this.sessionService, null);
        this.repo.addListener(new VDBLifeCycleListener(){

            public void added(String name, int version, CompositeVDB vdb) {
            }

            public void removed(String name, int version, CompositeVDB vdb) {
            }

            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
                GlobalTableStoreImpl gts = new GlobalTableStoreImpl(FakeServer.this.dqp.getBufferManager(), (QueryMetadataInterface)vdb.getVDB().getAttachment(TransformationMetadata.class));
                if (FakeServer.this.replicator != null) {
                    try {
                        gts = (GlobalTableStore)FakeServer.this.replicator.replicate(name + version, GlobalTableStore.class, (Object)gts, 300000L);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                vdb.getVDB().addAttchment(GlobalTableStore.class, (Object)gts);
            }
        });
        this.repo.setSystemStore(VDBMetadataFactory.getSystem());
        this.repo.setSystemFunctionManager(new SystemFunctionManager());
        this.repo.odbcEnabled();
        this.repo.start();
        this.sessionService.setVDBRepository(this.repo);
        if (!realBufferMangaer) {
            this.dqp.setBufferService((BufferService)new FakeBufferService());
        } else {
            BufferServiceImpl bsi = new BufferServiceImpl();
            bsi.setDiskDirectory(UnitTestUtil.getTestScratchPath());
            this.dqp.setBufferService((BufferService)bsi);
            bsi.start();
        }
        this.dqp.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.dqp.setTransactionService((TransactionService)new FakeTransactionService());
        this.cmr = new ConnectorManagerRepository(){

            public ConnectorManager getConnectorManager(String connectorName) {
                ConnectorManager cm = super.getConnectorManager(connectorName);
                if (cm != null) {
                    return cm;
                }
                if (connectorName.equalsIgnoreCase("source")) {
                    return new ConnectorManager("x", "x"){

                        public SourceCapabilities getCapabilities() {
                            return new BasicSourceCapabilities();
                        }
                    };
                }
                return null;
            }
        };
        config.setResultsetCacheConfig(new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, 250, "resultsetcache"));
        this.dqp.setCacheFactory((CacheFactory)new DefaultCacheFactory(){

            public boolean isReplicated() {
                return true;
            }
        });
        this.dqp.start(config);
        this.sessionService.setDqp(this.dqp);
        this.registerClientService(ILogon.class, this.logon, null);
        this.registerClientService(DQP.class, this.dqp, null);
    }

    public DQPCore getDqp() {
        return this.dqp;
    }

    public ConnectorManagerRepository getConnectorManagerRepository() {
        return this.cmr;
    }

    public void setConnectorManagerRepository(ConnectorManagerRepository cmr) {
        this.cmr = cmr;
    }

    public void stop() {
        this.dqp.stop();
    }

    public void setMetadataRepository(MetadataRepository metadataRepository) {
        this.repo.setMetadataRepository(metadataRepository);
        this.dqp.setMetadataRepository(metadataRepository);
    }

    public void setUseCallingThread(boolean useCallingThread) {
        this.useCallingThread = useCallingThread;
    }

    public void deployVDB(String vdbName, String vdbPath) throws Exception {
        this.deployVDB(vdbName, vdbPath, null);
    }

    public void deployVDB(String vdbName, String vdbPath, Map<String, Collection<FunctionMethod>> udfs) throws Exception {
        IndexMetadataFactory imf = VDBMetadataFactory.loadMetadata((URL)new File(vdbPath).toURI().toURL());
        MetadataStore metadata = imf.getMetadataStore(this.repo.getSystemStore().getDatatypes());
        LinkedHashMap entries = imf.getEntriesPlusVisibilities();
        this.deployVDB(vdbName, metadata, entries, udfs);
    }

    public void deployVDB(String vdbName, MetadataStore metadata, LinkedHashMap<String, TransformationMetadata.Resource> entries) {
        this.deployVDB(vdbName, metadata, entries, null);
    }

    public void deployVDB(String vdbName, MetadataStore metadata, LinkedHashMap<String, TransformationMetadata.Resource> entries, Map<String, Collection<FunctionMethod>> udfs) {
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setStatus(VDB.Status.ACTIVE);
        for (Schema schema : this.repo.getSystemStore().getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        for (Schema schema : this.repo.getODBCStore().getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        for (Schema schema : metadata.getSchemas().values()) {
            this.addModel(vdbMetaData, schema);
        }
        try {
            MetadataStoreGroup stores = new MetadataStoreGroup();
            stores.addStore(metadata);
            UDFMetaData udfMetaData = null;
            if (udfs != null) {
                udfMetaData = new UDFMetaData();
                for (Map.Entry<String, Collection<FunctionMethod>> entry : udfs.entrySet()) {
                    udfMetaData.addFunctions(entry.getKey(), entry.getValue());
                }
            }
            this.repo.addVDB(vdbMetaData, stores, entries, udfMetaData, this.cmr);
            this.repo.finishDeployment(vdbName, 1);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    private void addModel(VDBMetaData vdbMetaData, Schema schema) {
        ModelMetaData model = new ModelMetaData();
        model.setName(schema.getName());
        vdbMetaData.addModel(model);
        model.addSourceMapping("source", "translator", "jndi:source");
    }

    public VDBMetaData getVDB(String vdbName) {
        return this.repo.getVDB(vdbName, 1);
    }

    public void undeployVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    public void mergeVDBS(String sourceVDB, String targetVDB) throws AdminException {
        this.repo.mergeVDBs(sourceVDB, 1, targetVDB, 1);
    }

    public ConnectionImpl createConnection(String embeddedURL) throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)embeddedURL, (Properties)p);
        return this.connect(embeddedURL, p);
    }

    public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
        LocalServerConnection conn;
        try {
            conn = new LocalServerConnection(info, this.useCallingThread){

                protected ClientServiceRegistry getClientServiceRegistry() {
                    return FakeServer.this;
                }
            };
        }
        catch (CommunicationException e) {
            throw TeiidSQLException.create((Throwable)e);
        }
        catch (ConnectionException e) {
            throw TeiidSQLException.create((Throwable)e);
        }
        return new ConnectionImpl((ServerConnection)conn, info, url);
    }
}

