/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.progress.OngoingStubbing;
import org.mockito.internal.progress.VerificationMode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.ReusableExecution;
import org.teiid.translator.TranslatorException;

public class TestExecutionReuse {
    private static final int EXEC_COUNT = 3;
    private static FakeServer server;
    private static FakeReusableExecution execution;

    @Before
    public void setup() throws DataNotAvailableException, TranslatorException {
        execution = (FakeReusableExecution)Mockito.mock(FakeReusableExecution.class);
        OngoingStubbing stubbing = Mockito.stub(execution.next()).toReturn(Arrays.asList(new Object[]{null})).toReturn(null);
        for (int i = 1; i < 3; ++i) {
            stubbing.toReturn(Arrays.asList(new Object[]{null})).toReturn(null);
        }
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        DQPConfiguration config = new DQPConfiguration();
        config.setUserRequestSourceConcurrency(1);
        server = new FakeServer(config);
        server.setConnectorManagerRepository(new ConnectorManagerRepository(){
            private ConnectorManager cm = new ConnectorManager("x", "y"){
                private ExecutionFactory<Object, Object> ef;
                {
                    this.ef = new ExecutionFactory<Object, Object>(){

                        public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                            return execution;
                        }
                    };
                }

                public ExecutionFactory<Object, Object> getExecutionFactory() {
                    return this.ef;
                }

                public Object getConnectionFactory() throws TranslatorException {
                    return null;
                }
            };

            public ConnectorManager getConnectorManager(String connectorName) {
                return this.cm;
            }
        });
        server.deployVDB("PartsSupplier", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        server.stop();
    }

    @Test
    public void testReusableAsynchContinuous() throws Exception {
        ConnectionImpl c = server.createConnection("jdbc:teiid:partssupplier");
        Statement s = c.createStatement();
        TeiidStatement ts = s.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select part_id from parts", new StatementCallback(){
            int rowCount;

            public void onRow(Statement s, ResultSet rs) throws SQLException {
                ++this.rowCount;
                if (this.rowCount == 3) {
                    s.close();
                }
            }

            public void onException(Statement s, Exception e) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }

            public void onComplete(Statement s) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Assert.assertEquals((long)3L, (long)((Integer)result.get()).intValue());
        ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)1))).dispose();
        ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).execute();
        ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).close();
        ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)2))).reset((Command)Mockito.anyObject(), (ExecutionContext)Mockito.anyObject(), Mockito.anyObject());
    }

    private static class FakeReusableExecution
    implements ResultSetExecution,
    ReusableExecution<Object> {
        private FakeReusableExecution() {
        }

        public List<?> next() throws TranslatorException, DataNotAvailableException {
            return null;
        }

        public void cancel() throws TranslatorException {
        }

        public void close() {
        }

        public void execute() throws TranslatorException {
        }

        public void dispose() {
        }

        public void reset(Command c, ExecutionContext executionContext, Object connection) {
        }
    }
}

