/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;

public class TestMatViews {
    private static final String MATVIEWS = "matviews";
    private Connection conn;
    private FakeServer server;
    private static int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pause() throws InterruptedException {
        Class<TestMatViews> clazz = TestMatViews.class;
        synchronized (TestMatViews.class) {
            ++count;
            TestMatViews.class.notify();
            while (count < 2) {
                TestMatViews.class.wait();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return 1;
        }
    }

    @Before
    public void setUp() throws Exception {
        this.server = new FakeServer();
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("funcs", Arrays.asList(new FunctionMethod("pause", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestMatViews.class.getName(), "pause", null, new FunctionParameter("return", "integer"), true, FunctionMethod.Determinism.NONDETERMINISTIC)));
        this.server.deployVDB(MATVIEWS, UnitTestUtil.getTestDataPath() + "/matviews.vdb", udfs);
        this.conn = this.server.createConnection("jdbc:teiid:matviews");
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
        this.conn.close();
    }

    @Test
    public void testSystemMatViewsWithImplicitLoad() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from MatViews order by name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.ERRORVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)"#MAT_TEST.MATVIEW", (Object)rs.getString("targetName"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        Assert.assertEquals((Object)"#MAT_TEST.RANDOMVIEW", (Object)rs.getString("targetName"));
        rs = s.executeQuery("select * from MatView");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        try {
            s.executeQuery("select * from ErrorView");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        rs = s.executeQuery("select * from MatViews where name = 'ErrorView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"FAILED_LOAD", (Object)rs.getString("loadstate"));
    }

    @Test
    public void testSystemMatViewsWithExplicitRefresh() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key1 = rs.getDouble(1);
        Assert.assertTrue((key1 != key ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemManViewsWithExplictRefreshAndInvalidate() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'MatView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        count = 0;
        s.execute("alter view TEST.MATVIEW as select pause() as x");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Statement s1 = TestMatViews.this.conn.createStatement();
                    ResultSet rs = s1.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', true)) p");
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
        };
        t.start();
        Class<TestMatViews> clazz = TestMatViews.class;
        synchronized (TestMatViews.class) {
            while (count < 1) {
                TestMatViews.class.wait();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            rs = s.executeQuery("select * from MatViews where name = 'MatView'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
            clazz = TestMatViews.class;
            synchronized (TestMatViews.class) {
                ++count;
                TestMatViews.class.notify();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                t.join();
                rs = s.executeQuery("select * from MatViews where name = 'MatView'");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
                Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
                return;
            }
        }
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('TEST.NotMat', false)");
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsInvalidView1() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("call refreshMatView('foo', false)");
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsWithRowRefreshNotAllowed() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("alter view test.randomview as select rand() as x, rand() as y");
        ResultSet rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
    }

    @Test
    public void testSystemMatViewsWithRowRefresh() throws Exception {
        Statement s = this.conn.createStatement();
        s.execute("alter view test.randomview as /*+ cache(updatable) */ select rand() as x, rand() as y");
        ResultSet rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', 0)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)-1L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from MatViews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select x from TEST.RANDOMVIEW");
        Assert.assertTrue((boolean)rs.next());
        double key = rs.getDouble(1);
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = s.executeQuery("select * from TEST.RANDOMVIEW");
        Assert.assertFalse((boolean)rs.next());
        rs = s.executeQuery("select * from (call refreshMatViewRow('TEST.RANDOMVIEW', " + key + ")) p");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
    }

    @Test(expected=TeiidSQLException.class)
    public void testSystemMatViewsWithRowRefreshNoPk() throws Exception {
        Statement s = this.conn.createStatement();
        s.executeQuery("select * from (call refreshMatView('TEST.MATVIEW', false)) p");
        s.executeQuery("select * from (call refreshMatViewRow('TEST.MATVIEW', 0)) p");
    }
}

