/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.language.Command;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;

public class TestLocalConnections {
    static ReentrantLock lock = new ReentrantLock();
    static Condition waiting = lock.newCondition();
    static Condition wait = lock.newCondition();
    static Semaphore sourceCounter = new Semaphore(0);
    static FakeServer server = new FakeServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int blocking() throws InterruptedException {
        lock.lock();
        try {
            waiting.signal();
            if (!wait.await(2L, TimeUnit.SECONDS)) {
                throw new RuntimeException();
            }
        }
        finally {
            lock.unlock();
        }
        return 1;
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server.setUseCallingThread(true);
        server.setConnectorManagerRepository(new ConnectorManagerRepository(){

            public ConnectorManager getConnectorManager(String connectorName) {
                return new ConnectorManager(connectorName, connectorName){

                    public ExecutionFactory<Object, Object> getExecutionFactory() {
                        return new ExecutionFactory<Object, Object>(){

                            public Execution createExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                                return new ResultSetExecution(){
                                    boolean returnedRow = false;

                                    public void execute() throws TranslatorException {
                                        lock.lock();
                                        try {
                                            sourceCounter.release();
                                            if (!wait.await(2L, TimeUnit.SECONDS)) {
                                                throw new RuntimeException();
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            throw new RuntimeException(e);
                                        }
                                        finally {
                                            lock.unlock();
                                        }
                                    }

                                    public void close() {
                                    }

                                    public void cancel() throws TranslatorException {
                                    }

                                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                                        if (this.returnedRow) {
                                            return null;
                                        }
                                        this.returnedRow = true;
                                        return new ArrayList<Object>(Collections.singleton(null));
                                    }
                                };
                            }
                        };
                    }

                    protected Object getConnectionFactory() throws TranslatorException {
                        return null;
                    }
                };
            }
        });
        FunctionMethod function = new FunctionMethod("foo", null, "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestLocalConnections.class.getName(), "blocking", new FunctionParameter[0], new FunctionParameter("result", "integer"), true, FunctionMethod.Determinism.NONDETERMINISTIC);
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("test", Arrays.asList(function));
        server.deployVDB("PartsSupplier", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb", udfs);
    }

    @AfterClass
    public static void oneTimeTearDown() {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentExection() throws Throwable {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
                    Statement s = c.createStatement();
                    s.execute("select foo()");
                    s.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        t.start();
        lock.lock();
        try {
            waiting.await();
        }
        finally {
            lock.unlock();
        }
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Statement s = c.createStatement();
        s.execute("select * from tables");
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join(2000L);
        if (t.isAlive()) {
            Assert.fail();
        }
        s.close();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    @Test
    public void testUseInDifferentThreads() throws Throwable {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        final Statement s = c.createStatement();
        s.execute("select 1");
        Assert.assertFalse((boolean)TestLocalConnections.server.dqp.getRequests().isEmpty());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        t.start();
        t.join(2000L);
        if (t.isAlive()) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)TestLocalConnections.server.dqp.getRequests().isEmpty());
        if (handler.t != null) {
            throw handler.t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWait() throws Throwable {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Thread t = new Thread((Connection)c){
            final /* synthetic */ Connection val$c;
            {
                this.val$c = connection;
            }

            @Override
            public void run() {
                try {
                    Statement s = this.val$c.createStatement();
                    Assert.assertTrue((boolean)s.execute("select part_id from parts"));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        sourceCounter.acquire();
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitMultiple() throws Throwable {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Thread t = new Thread((Connection)c){
            final /* synthetic */ Connection val$c;
            {
                this.val$c = connection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Statement s = this.val$c.createStatement();
                    Assert.assertTrue((boolean)s.execute("select part_id from parts union all select part_id from parts"));
                    ResultSet r = s.getResultSet();
                    lock.lock();
                    try {
                        wait.signal();
                    }
                    finally {
                        lock.unlock();
                    }
                    Thread.sleep(1000L);
                    while (r.next()) {
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        sourceCounter.acquire(2);
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    private final class SimpleUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Throwable t;

        private SimpleUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread arg0, Throwable arg1) {
            this.t = arg1;
        }
    }
}

