/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.DefaultMetadataRepository;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Table;

public class TestMetadataUpdates {
    static Connection connection;
    static final String VDB = "metadata";

    @BeforeClass
    public static void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/metadata.vdb", new FakeServer.DeployVDBParameter(null, (MetadataRepository)TestMetadataUpdates.getMetadataRepo()));
        connection = server.createConnection("jdbc:teiid:metadata");
    }

    private static DefaultMetadataRepository getMetadataRepo() {
        DefaultMetadataRepository repo = (DefaultMetadataRepository)Mockito.mock(DefaultMetadataRepository.class);
        Mockito.stub((Object)repo.getViewDefinition(Mockito.anyString(), Mockito.anyInt(), (Table)Mockito.anyObject())).toAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Table t = (Table)invocation.getArguments()[2];
                if (t.getName().equals("vw")) {
                    return "select '2011'";
                }
                return null;
            }
        });
        Mockito.stub((Object)repo.getProcedureDefinition(Mockito.anyString(), Mockito.anyInt(), (Procedure)Mockito.anyObject())).toAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                Procedure t = (Procedure)invocation.getArguments()[2];
                if (t.getName().equals("proc")) {
                    return "create virtual procedure begin select '2011'; if ((call isLoggable())) call logMsg(msg=>'hello'); end";
                }
                return null;
            }
        });
        Mockito.stub((Object)repo.getInsteadOfTriggerDefinition(Mockito.anyString(), Mockito.anyInt(), (Table)Mockito.anyObject(), (Table.TriggerEvent)Mockito.anyObject())).toAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return "for each row select 1/0;";
            }
        });
        Mockito.stub((Object)repo.isInsteadOfTriggerEnabled(Mockito.anyString(), Mockito.anyInt(), (Table)Mockito.anyObject(), (Table.TriggerEvent)Mockito.anyObject())).toAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return Boolean.TRUE;
            }
        });
        return repo;
    }

    @AfterClass
    public static void tearDown() throws SQLException {
        connection.close();
    }

    @Test
    public void testViewMetadataRepositoryMerge() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
    }

    @Test(expected=SQLException.class)
    public void testViewUpdateMetadataRepositoryMerge() throws Exception {
        Statement s = connection.createStatement();
        s.execute("delete from vw");
    }

    @Test
    public void testProcMetadataRepositoryMerge() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
    }

    @Test
    public void testSetProperty() throws Exception {
        CallableStatement s = connection.prepareCall("{? = call sysadmin.setProperty((select uid from tables where name='vw'), 'foo', 'bar')}");
        Assert.assertFalse((boolean)s.execute());
        Assert.assertNull((Object)s.getClob(1));
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("select name, \"value\" from properties where uid = (select uid from tables where name='vw')");
        rs.next();
        Assert.assertEquals((Object)"foo", (Object)rs.getString(1));
        Assert.assertEquals((Object)"bar", (Object)rs.getString(2));
    }

    @Test(expected=SQLException.class)
    public void testSetProperty_Invalid() throws Exception {
        CallableStatement s = connection.prepareCall("{? = call sysadmin.setProperty('ah', 'foo', 'bar')}");
        s.execute();
    }

    @Test
    public void testAlterView() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)s.execute("alter view vw as select '2012'"));
        rs = s.executeQuery("select * from vw");
        rs.next();
        Assert.assertEquals((long)2012L, (long)rs.getInt(1));
    }

    @Test
    public void testAlterProcedure() throws Exception {
        Statement s = connection.createStatement();
        ResultSet rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2011L, (long)rs.getInt(1));
        Assert.assertFalse((boolean)s.execute("alter procedure proc as begin select '2012'; end"));
        Thread.sleep(100L);
        rs = s.executeQuery("call proc(1)");
        rs.next();
        Assert.assertEquals((long)2012L, (long)rs.getInt(1));
    }

    @Test
    public void testAlterTriggerActionUpdate() throws Exception {
        Statement s = connection.createStatement();
        try {
            s.execute("update vw set x = 1");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of update as for each row select 1;"));
        s.execute("update vw set x = 1");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test
    public void testAlterTriggerActionInsert() throws Exception {
        Statement s = connection.createStatement();
        try {
            s.execute("insert into vw (x) values ('a')");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of insert as for each row select 1;"));
        s.execute("insert into vw (x) values ('a')");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test
    public void testAlterTriggerActionDelete() throws Exception {
        Statement s = connection.createStatement();
        try {
            s.execute("delete from vw");
            Assert.fail();
        }
        catch (SQLException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete as for each row select 1;"));
        s.execute("delete from vw");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete disabled"));
        try {
            s.execute("delete from vw");
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)s.execute("alter trigger on vw instead of delete enabled"));
        s.execute("delete from vw");
        Assert.assertEquals((long)1L, (long)s.getUpdateCount());
    }

    @Test(expected=SQLException.class)
    public void testCreateTriggerActionUpdate() throws Exception {
        Statement s = connection.createStatement();
        s.execute("create trigger on vw instead of update as for each row select 1;");
    }
}

