/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.metadata.Table;

public class TestGroup
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestGroup.createTranslationUtility(TestGroup.getTestVDBName());

    public TestGroup(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Table getGroup(String groupName, TranslationUtility transUtil) throws Exception {
        Select query = (Select)transUtil.parseCommand("SELECT 1 FROM " + groupName);
        NamedTable group = (NamedTable)query.getFrom().get(0);
        return group.getMetadataObject();
    }

    public void helpTestGroup(String fullGroupName, String nameInSource, Properties expectedProps, TranslationUtility transUtil) throws Exception {
        Table group = this.getGroup(fullGroupName, transUtil);
        TestGroup.assertEquals((String)"table name in source", (String)group.getNameInSource());
        Map extProps = group.getProperties();
        TestGroup.assertEquals((Object)expectedProps, (Object)extProps);
    }

    public void testGroup() throws Exception {
        Properties props = new Properties();
        props.put("TestExtraProperty", "extension prop value");
        this.helpTestGroup("ConnectorMetadata.TestTable", "TestTable", props, CONNECTOR_METADATA_UTILITY);
    }
}

