/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.security.SimplePrincipal;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.Base64;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.service.SessionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.language.Command;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.LogonImpl;

public class TestLocalConnections {
    static ReentrantLock lock = new ReentrantLock();
    static Condition waiting = lock.newCondition();
    static Condition wait = lock.newCondition();
    static Semaphore sourceCounter = new Semaphore(0);
    static FakeServer server = new FakeServer(true);
    static int calls;
    static Subject currentContext;

    public static int blocking() throws InterruptedException {
        lock.lock();
        try {
            waiting.signal();
            if (!wait.await(2L, TimeUnit.SECONDS)) {
                throw new RuntimeException();
            }
        }
        finally {
            lock.unlock();
        }
        return 1;
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server.setUseCallingThread(true);
        server.setConnectorManagerRepository(new ConnectorManagerRepository(){

            public ConnectorManager getConnectorManager(String connectorName) {
                return new ConnectorManager(connectorName, connectorName){

                    public ExecutionFactory<Object, Object> getExecutionFactory() {
                        return new ExecutionFactory<Object, Object>(){

                            public boolean isSourceRequired() {
                                return false;
                            }

                            public Execution createExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                                return new ResultSetExecution(){
                                    boolean returnedRow = false;

                                    public void execute() throws TranslatorException {
                                        lock.lock();
                                        try {
                                            sourceCounter.release();
                                            if (!wait.await(5L, TimeUnit.SECONDS)) {
                                                throw new RuntimeException();
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            throw new RuntimeException(e);
                                        }
                                        finally {
                                            lock.unlock();
                                        }
                                    }

                                    public void close() {
                                    }

                                    public void cancel() throws TranslatorException {
                                    }

                                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                                        if (this.returnedRow) {
                                            return null;
                                        }
                                        this.returnedRow = true;
                                        return new ArrayList<Object>(Collections.singleton(null));
                                    }
                                };
                            }
                        };
                    }

                    public Object getConnectionFactory() throws TranslatorException {
                        return null;
                    }
                };
            }
        });
        FunctionMethod function = new FunctionMethod("foo", null, "Miscellaneous", FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestLocalConnections.class.getName(), "blocking", null, new FunctionParameter("result", "integer"), false, FunctionMethod.Determinism.NONDETERMINISTIC);
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("test", Arrays.asList(function));
        server.deployVDB("PartsSupplier", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb", new FakeServer.DeployVDBParameter(udfs, null));
    }

    @AfterClass
    public static void oneTimeTearDown() {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentExection() throws Throwable {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
                    Statement s = c.createStatement();
                    s.execute("select foo()");
                    s.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        t.start();
        lock.lock();
        try {
            waiting.await();
        }
        finally {
            lock.unlock();
        }
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Statement s = c.createStatement();
        s.execute("select * from tables");
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join(2000L);
        if (t.isAlive()) {
            Assert.fail();
        }
        s.close();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    @Test
    public void testUseInDifferentThreads() throws Throwable {
        for (int i = 0; !server.getDqp().getRequests().isEmpty() && i < 40; ++i) {
            Thread.sleep(50L);
        }
        int count = server.getDqp().getRequests().size();
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        final Statement s = c.createStatement();
        s.execute("select 1");
        Assert.assertFalse((boolean)server.getDqp().getRequests().isEmpty());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        t.start();
        t.join(2000L);
        if (t.isAlive()) {
            Assert.fail();
        }
        if (handler.t != null) {
            throw handler.t;
        }
        for (int i = 0; server.getDqp().getRequests().size() != count && i < 40; ++i) {
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)count, (long)server.getDqp().getRequests().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWait() throws Throwable {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Thread t = new Thread((Connection)c){
            final /* synthetic */ Connection val$c;
            {
                this.val$c = connection;
            }

            @Override
            public void run() {
                try {
                    Statement s = this.val$c.createStatement();
                    Assert.assertTrue((boolean)s.execute("select part_id from parts"));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        sourceCounter.acquire();
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitMultiple() throws Throwable {
        ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier");
        Thread t = new Thread((Connection)c){
            final /* synthetic */ Connection val$c;
            {
                this.val$c = connection;
            }

            @Override
            public void run() {
                try {
                    Statement s = this.val$c.createStatement();
                    Assert.assertTrue((boolean)s.execute("select part_id from parts union all select part_name from parts"));
                    ResultSet r = s.getResultSet();
                    lock.lock();
                    try {
                        wait.signal();
                    }
                    finally {
                        lock.unlock();
                    }
                    Thread.sleep(1000L);
                    while (r.next()) {
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        SimpleUncaughtExceptionHandler handler = new SimpleUncaughtExceptionHandler();
        t.setUncaughtExceptionHandler(handler);
        sourceCounter.acquire(2);
        lock.lock();
        try {
            wait.signal();
        }
        finally {
            lock.unlock();
        }
        t.join();
        if (handler.t != null) {
            throw handler.t;
        }
    }

    @Test
    public void testWaitForLoad() throws Exception {
        final ResultsFuture future = new ResultsFuture();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    server.createConnection("jdbc:teiid:not_there.1");
                    future.getResultsReceiver().receiveResults(null);
                }
                catch (Exception e) {
                    future.getResultsReceiver().exceptionOccurred((Throwable)e);
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Assert.assertFalse((boolean)future.isDone());
        try {
            server.deployVDB("not_there", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
            future.get(5000L, TimeUnit.SECONDS);
        }
        finally {
            server.undeployVDB("not_there");
        }
        try {
            server.createConnection("jdbc:teiid:not_there.1;waitForLoad=0");
            Assert.fail();
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPassThroughDifferentUsers() throws Throwable {
        SecurityHelper securityHelper = new SecurityHelper(){

            public Subject getSubjectInContext(String securityDomain) {
                return currentContext;
            }

            public Object getSecurityContext() {
                ++calls;
                return currentContext;
            }

            public void clearSecurityContext() {
            }

            public Object associateSecurityContext(Object context) {
                Subject result = currentContext;
                currentContext = (Subject)context;
                return result;
            }

            public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
                return null;
            }

            public GSSResult neogitiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
                return null;
            }
        };
        SecurityHelper current = server.getSessionService().getSecurityHelper();
        server.getClientServiceRegistry().setSecurityHelper(securityHelper);
        server.getSessionService().setSecurityHelper(securityHelper);
        try {
            ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier;PassthroughAuthentication=true");
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery("select session_id()");
            Subject o = currentContext;
            currentContext = null;
            s.cancel();
            currentContext = o;
            rs.next();
            String id = rs.getString(1);
            rs.close();
            Assert.assertEquals((long)4L, (long)calls);
            server.getSessionService().pingServer(id);
            currentContext = new Subject();
            currentContext.getPrincipals().add((Principal)new SimplePrincipal("x"));
            rs = s.executeQuery("select session_id()");
            rs.next();
            String id1 = rs.getString(1);
            rs.close();
            Assert.assertFalse((boolean)id.equals(id1));
            try {
                server.getSessionService().pingServer(id);
                Assert.fail();
            }
            catch (InvalidSessionException e) {
                // empty catch block
            }
        }
        finally {
            server.getClientServiceRegistry().setSecurityHelper(current);
            server.getSessionService().setSecurityHelper(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimulateGSSWithODBC() throws Throwable {
        SecurityHelper securityHelper = new SecurityHelper(){

            public Subject getSubjectInContext(String securityDomain) {
                return new Subject();
            }

            public Object getSecurityContext() {
                return currentContext;
            }

            public void clearSecurityContext() {
            }

            public Object associateSecurityContext(Object context) {
                Subject result = currentContext;
                currentContext = (Subject)context;
                return result;
            }

            public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
                return null;
            }

            public GSSResult neogitiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
                return null;
            }
        };
        SecurityHelper current = server.getSessionService().getSecurityHelper();
        server.getClientServiceRegistry().setSecurityHelper(securityHelper);
        server.getSessionService().setSecurityHelper(securityHelper);
        server.getSessionService().setAuthenticationType(AuthenticationType.GSS);
        final byte[] token = "This is test of Partial GSS API".getBytes();
        final AtomicBoolean set = new AtomicBoolean(true);
        LogonImpl login = new LogonImpl((SessionService)server.getSessionService(), null){

            public LogonResult logon(Properties connProps) throws LogonException {
                if (set.get()) {
                    this.gssServiceTickets.put(Base64.encodeBytes((byte[])9.MD5((byte[])token)), currentContext);
                    set.set(false);
                }
                return super.logon(connProps);
            }
        };
        server.getClientServiceRegistry().registerClientService(ILogon.class, (Object)login, "org.teiid.SECURITY");
        try {
            Properties prop = new Properties();
            prop.put("KRB5TOKEN", token);
            ConnectionImpl c = server.createConnection("jdbc:teiid:PartsSupplier;user=GSS", prop);
            Statement s = c.createStatement();
            ResultSet rs = s.executeQuery("select session_id()");
            Subject o = currentContext;
            currentContext = null;
            s.cancel();
            currentContext = o;
            rs.next();
            String id = rs.getString(1);
            rs.close();
        }
        finally {
            server.getSessionService().setAuthenticationType(AuthenticationType.USERPASSWORD);
            server.getClientServiceRegistry().setSecurityHelper(current);
            server.getSessionService().setSecurityHelper(current);
        }
    }

    static {
        currentContext = new Subject();
    }

    private final class SimpleUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        volatile Throwable t;

        private SimpleUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread arg0, Throwable arg1) {
            this.t = arg1;
        }
    }
}

