/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.TeiidStatement;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.util.CommandContext;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.ReusableExecution;
import org.teiid.translator.TranslatorException;

public class TestExecutionReuse {
    private static final int EXEC_COUNT = 3;
    private static FakeServer server;
    private static FakeReusableExecution execution;
    private static boolean isDisposed;
    private static ExecutionContext ec;

    @Before
    public void setup() throws DataNotAvailableException, TranslatorException {
        execution = (FakeReusableExecution)Mockito.mock(FakeReusableExecution.class);
        ec = null;
        DeprecatedOngoingStubbing stubbing = Mockito.stub(execution.next()).toReturn(Arrays.asList(new Object[]{null})).toReturn(null);
        for (int i = 1; i < 3; ++i) {
            stubbing.toReturn(Arrays.asList(new Object[]{null})).toReturn(null);
        }
        ((FakeReusableExecution)Mockito.doAnswer((Answer)new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocation) throws Throwable {
                Class<TestExecutionReuse> clazz = TestExecutionReuse.class;
                synchronized (TestExecutionReuse.class) {
                    isDisposed = true;
                    TestExecutionReuse.class.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
        }).when((Object)execution)).dispose();
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.setUserRequestSourceConcurrency(1);
        server = new FakeServer(false);
        server.setConnectorManagerRepository(new ConnectorManagerRepository(){
            private ConnectorManager cm = new ConnectorManager("x", "y"){
                private ExecutionFactory<Object, Object> ef;
                {
                    this.ef = new ExecutionFactory<Object, Object>(){

                        public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                            ec = executionContext;
                            return execution;
                        }

                        public boolean isSourceRequired() {
                            return false;
                        }
                    };
                }

                public ExecutionFactory<Object, Object> getExecutionFactory() {
                    return this.ef;
                }

                public Object getConnectionFactory() throws TranslatorException {
                    return null;
                }
            };

            public ConnectorManager getConnectorManager(String connectorName) {
                return this.cm;
            }
        });
        server.start(config, false);
        server.deployVDB("PartsSupplier", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReusableAsynchContinuous() throws Exception {
        ConnectionImpl c = server.createConnection("jdbc:teiid:partssupplier");
        Statement s = c.createStatement();
        TeiidStatement ts = s.unwrap(TeiidStatement.class);
        final ResultsFuture result = new ResultsFuture();
        ts.submitExecute("select part_id from parts order by part_id", new StatementCallback(){
            int rowCount;

            public void onRow(Statement stmt, ResultSet rs) throws SQLException {
                ++this.rowCount;
                if (this.rowCount == 3) {
                    stmt.close();
                }
            }

            public void onException(Statement stmt, Exception e) {
                result.getResultsReceiver().exceptionOccurred((Throwable)e);
            }

            public void onComplete(Statement stmt) {
                result.getResultsReceiver().receiveResults((Object)this.rowCount);
            }
        }, new RequestOptions().continuous(true));
        Class<TestExecutionReuse> clazz = TestExecutionReuse.class;
        synchronized (TestExecutionReuse.class) {
            while (!isDisposed) {
                TestExecutionReuse.class.wait();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Assert.assertEquals((long)3L, (long)((Integer)result.get()).intValue());
            Assert.assertTrue((boolean)ec.getCommandContext().isContinuous());
            ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)1))).dispose();
            ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).execute();
            ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)3))).close();
            ((FakeReusableExecution)Mockito.verify((Object)execution, (VerificationMode)Mockito.times((int)2))).reset((Command)Mockito.anyObject(), (ExecutionContext)Mockito.anyObject(), Mockito.anyObject());
            return;
        }
    }

    @Test
    public void testCommandContext() {
        CommandContext cc = new CommandContext();
        FakeReusableExecution fe = new FakeReusableExecution();
        cc.putReusableExecution((Object)"a", (ReusableExecution)fe);
        cc.putReusableExecution((Object)"a", (ReusableExecution)new FakeReusableExecution());
        ReusableExecution re = cc.getReusableExecution((Object)"a");
        ReusableExecution re1 = cc.getReusableExecution((Object)"a");
        Assert.assertSame((Object)fe, (Object)re);
        Assert.assertNotSame((Object)fe, (Object)re1);
        Assert.assertNull((Object)cc.getReusableExecution((Object)"a"));
    }

    private static class FakeReusableExecution
    implements ResultSetExecution,
    ReusableExecution<Object> {
        private FakeReusableExecution() {
        }

        public List<?> next() throws TranslatorException, DataNotAvailableException {
            return null;
        }

        public void cancel() throws TranslatorException {
        }

        public void close() {
        }

        public void execute() throws TranslatorException {
        }

        public void dispose() {
        }

        public void reset(Command c, ExecutionContext executionContext, Object connection) {
        }
    }
}

