/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestVDBSeviceCleanup
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testServiceCleanup() throws Exception {
        this.admin.deploy("service-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"service-vdb.xml")));
        this.createDS("ServiceDS");
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "service", 1, 3));
        Assert.assertNotNull((Object)TeiidDriver.getInstance().connect("jdbc:teiid:service@mm://localhost:31000;user=user;password=user", null));
        this.admin.undeploy("service-vdb.xml");
        this.admin.deleteDataSource("ServiceDS");
        this.admin.deploy("service-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"service-vdb.xml")));
        this.createDS("ServiceDS");
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "service", 1, 3));
        Assert.assertNotNull((Object)TeiidDriver.getInstance().connect("jdbc:teiid:service@mm://localhost:31000;user=user;password=user", null));
    }

    private void createDS(String deployName) throws AdminException {
        Properties props = new Properties();
        props.setProperty("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        props.setProperty("user-name", "sa");
        props.setProperty("password", "sa");
        AdminUtil.createDataSource(this.admin, deployName, "h2", props);
    }
}

