/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestTransactions
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testViewDefinition() throws Exception {
        this.admin.deploy("txn-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"txn-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "txn", 1, 30));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:txn@mm://localhost:31000;user=user;password=user", null);
        this.execute("create local temporary table temp (x integer)");
        this.execute("call proc()");
        this.execute("start transaction");
        this.execute("call proc()");
        this.execute("insert into temp (x) values (1)");
        this.execute("select * from temp");
        this.assertRowCount(1);
        this.execute("rollback");
        this.execute("select * from temp");
        this.assertRowCount(0);
    }
}

