/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.common.queue.FakeWorkManager;
import org.teiid.core.util.SimpleMock;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.index.IndexMetadataStore;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.transport.ClientServiceRegistryImpl;

public class FakeServer
extends EmbeddedServer {
    private boolean realBufferManager;

    public FakeServer(boolean start) {
        this.waitForLoad = true;
        this.cmr = new EmbeddedServer.ProviderAwareConnectorManagerRepository(){

            public ConnectorManager getConnectorManager(String connectorName) {
                ConnectorManager cm = super.getConnectorManager(connectorName);
                if (cm != null) {
                    return cm;
                }
                if (connectorName.equalsIgnoreCase("source")) {
                    return new ConnectorManager("x", "x"){

                        public SourceCapabilities getCapabilities() {
                            return new BasicSourceCapabilities();
                        }
                    };
                }
                return null;
            }
        };
        if (start) {
            this.start(new EmbeddedConfiguration(), false);
        }
    }

    public void start(EmbeddedConfiguration config, boolean realBufferMangaer) {
        if (config.getTransactionManager() == null) {
            config.setTransactionManager((TransactionManager)SimpleMock.createSimpleMock(TransactionManager.class));
            this.transactionService.setXaTerminator((XATerminator)SimpleMock.createSimpleMock(XATerminator.class));
            this.transactionService.setWorkManager((WorkManager)new FakeWorkManager());
            this.detectTransactions = false;
        }
        this.repo.odbcEnabled();
        this.realBufferManager = realBufferMangaer;
        this.start(config);
    }

    protected BufferService getBufferService() {
        if (!this.realBufferManager) {
            return new FakeBufferService(false);
        }
        this.bufferService.setDiskDirectory(UnitTestUtil.getTestScratchPath());
        return super.getBufferService();
    }

    public DQPCore getDqp() {
        return this.dqp;
    }

    public ConnectorManagerRepository getConnectorManagerRepository() {
        return this.cmr;
    }

    public void setConnectorManagerRepository(ConnectorManagerRepository cmr) {
        this.cmr = cmr;
    }

    public void setUseCallingThread(boolean useCallingThread) {
        this.useCallingThread = useCallingThread;
    }

    public void deployVDB(String vdbName, String vdbPath) throws Exception {
        this.deployVDB(vdbName, vdbPath, new DeployVDBParameter(null, null));
    }

    public void deployVDB(String vdbName, String vdbPath, DeployVDBParameter parameterObject) throws Exception {
        IndexMetadataStore imf = VDBMetadataFactory.loadMetadata((String)vdbName, (URL)new File(vdbPath).toURI().toURL());
        this.deployVDB(vdbName, (MetadataStore)imf, parameterObject);
    }

    public void deployVDB(String vdbName, MetadataStore metadata) {
        this.deployVDB(vdbName, metadata, new DeployVDBParameter(null, null));
    }

    public void deployVDB(String vdbName, MetadataStore metadata, DeployVDBParameter parameterObject) {
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setStatus(VDB.Status.ACTIVE);
        for (Schema schema : metadata.getSchemas().values()) {
            ModelMetaData modelMetaData = this.addModel(vdbMetaData, schema);
            if (parameterObject.metadataRepo == null) continue;
            modelMetaData.addAttchment(MetadataRepository.class, parameterObject.metadataRepo);
        }
        try {
            UDFMetaData udfMetaData = null;
            if (parameterObject.udfs != null) {
                udfMetaData = new UDFMetaData();
                for (Map.Entry entry : parameterObject.udfs.entrySet()) {
                    udfMetaData.addFunctions((String)entry.getKey(), (Collection)entry.getValue());
                }
            }
            if (parameterObject.vdbImports != null) {
                for (VDBImportMetadata vDBImportMetadata : parameterObject.vdbImports) {
                    vdbMetaData.getVDBImports().add(vDBImportMetadata);
                }
            }
            this.repo.addVDB(vdbMetaData, metadata, metadata instanceof IndexMetadataStore ? ((IndexMetadataStore)metadata).getEntriesPlusVisibilities() : null, udfMetaData, this.cmr);
            this.repo.finishDeployment(vdbMetaData.getName(), vdbMetaData.getVersion());
            this.repo.getLiveVDB(vdbMetaData.getName(), vdbMetaData.getVersion()).setStatus(VDB.Status.ACTIVE);
        }
        catch (VirtualDatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    private ModelMetaData addModel(VDBMetaData vdbMetaData, Schema schema) {
        ModelMetaData model = new ModelMetaData();
        model.setModelType(schema.isPhysical() ? Model.Type.PHYSICAL : Model.Type.VIRTUAL);
        model.setName(schema.getName());
        vdbMetaData.addModel(model);
        model.addSourceMapping("source", "translator", "jndi:source");
        return model;
    }

    public VDBMetaData getVDB(String vdbName) {
        return this.repo.getLiveVDB(vdbName, 1);
    }

    public void undeployVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    public ConnectionImpl createConnection(String embeddedURL) throws Exception {
        return this.getDriver().connect(embeddedURL, null);
    }

    public ClientServiceRegistryImpl getClientServiceRegistry() {
        return this.services;
    }

    public void setThrowMetadataErrors(boolean throwMetadataErrors) {
        this.throwMetadataErrors = throwMetadataErrors;
    }

    public static class DeployVDBParameter {
        public Map<String, Collection<FunctionMethod>> udfs;
        public MetadataRepository<?, ?> metadataRepo;
        public List<VDBImportMetadata> vdbImports;

        public DeployVDBParameter(Map<String, Collection<FunctionMethod>> udfs, MetadataRepository<?, ?> metadataRepo) {
            this.udfs = udfs;
            this.metadataRepo = metadataRepo;
        }
    }
}

