/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestVirtualDocWithVirtualProc
extends AbstractMMQueryTestCase {
    private static final String VDB = "xmlvp";
    private static FakeServer server;

    public TestVirtualDocWithVirtualProc() {
        this.DELIMITER = "\t";
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.setThrowMetadataErrors(false);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/xml-vp/xmlvp_1.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() throws Exception {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:xmlvp");
    }

    @Override
    @After
    public void tearDown() {
        this.closeConnection();
    }

    @Test
    public void testDefect15241() throws Exception {
        String sql = "SELECT SchemaName, Name, Description FROM SYS.Tables WHERE Name = 'yyyTestDocument'";
        String[] expected = new String[]{"SchemaName[string]\tName[string]\tDescription[string]", "test13326Doc\tyyyTestDocument\tnull", "testDoc\tyyyTestDocument\tThis is a test description of virtual doc yyyTestDocument"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241a() throws Exception {
        String sql = "SELECT TableName, Name, Description FROM SYS.Columns WHERE Name = 'IntKey'";
        String[] expected = new String[]{"TableName[string]\tName[string]\tDescription[string]", "HugeA\tIntKey\tnull", "HugeB\tIntKey\tnull", "LargeA\tIntKey\tnull", "LargeB\tIntKey\tnull", "MediumA\tIntKey\tnull", "MediumB\tIntKey\tnull", "SmallA\tIntKey\tThis is a test description of SmallA.IntKey element", "SmallB\tIntKey\tnull"};
        this.executeAndAssertResults(sql, expected);
    }

    @Test
    public void testDefect15241b() throws Exception {
        String sql = "SELECT p.Name, p.Value, UID FROM SYS.Properties p order by p.Name";
        this.execute(sql);
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }
}

