/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestTransactions
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testViewDefinition() throws Exception {
        this.admin.deploy("txn-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"txn-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "txn", 1, 30));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:txn@mm://localhost:31000;user=user;password=user", null);
        this.execute("create local temporary table temp (x integer)");
        this.execute("call proc()");
        this.execute("start transaction");
        this.execute("call proc()");
        this.execute("insert into temp (x) values (1)");
        this.execute("select * from temp");
        this.assertRowCount(1);
        this.execute("rollback");
        this.execute("select * from temp");
        this.assertRowCount(0);
        this.execute("select rand(1)");
        this.internalConnection.setAutoCommit(false);
        this.execute("/*+ cache */ select rand()");
        this.internalResultSet.next();
        double d = this.internalResultSet.getDouble(1);
        this.execute("select rand(2)");
        this.execute("/*+ cache */ select rand()");
        this.internalResultSet.next();
        double d1 = this.internalResultSet.getDouble(1);
        Assert.assertEquals((String)"Expected same in the txn", (double)d, (double)d1, (double)0.0);
        this.internalConnection.rollback();
        this.internalConnection.setAutoCommit(true);
        this.execute("select rand(3)");
        this.execute("/*+ cache */ select rand()");
        this.internalResultSet.next();
        double d2 = this.internalResultSet.getDouble(1);
        Assert.assertTrue((String)"Expected different after rollback", (d != d2 ? 1 : 0) != 0);
        this.execute("select rand(4)");
        this.execute("/*+ cache */ select rand()");
        this.internalResultSet.next();
        d = this.internalResultSet.getDouble(1);
        Assert.assertEquals((String)"Expected same after autoCommit", (double)d, (double)d2, (double)0.0);
    }
}

