/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Call;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;

public class TestProcedure
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestProcedure.createTranslationUtility(TestProcedure.getTestVDBName());

    public TestProcedure(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Procedure getProcedure(String procName, int inputArgs, TranslationUtility transUtil) throws Exception {
        StringBuffer sql = new StringBuffer("EXEC " + procName + "(");
        if (inputArgs > 0) {
            sql.append("null");
            for (int i = 1; i < inputArgs; ++i) {
                sql.append(", null");
            }
        }
        sql.append(")");
        Call proc = (Call)transUtil.parseCommand(sql.toString());
        return proc.getMetadataObject();
    }

    public void testProcedure1() throws Exception {
        Procedure proc = this.getProcedure("ConnectorMetadata.TestProc1", 2, CONNECTOR_METADATA_UTILITY);
        TestProcedure.assertEquals((String)"Procedure name in source", (String)proc.getNameInSource());
        String[] nameInSource = new String[]{"Param name in source", null, null, null};
        ProcedureParameter.Type[] direction = new ProcedureParameter.Type[]{ProcedureParameter.Type.In, ProcedureParameter.Type.Out, ProcedureParameter.Type.InOut, ProcedureParameter.Type.ReturnValue};
        int[] index = new int[]{1, 2, 3, 4};
        Class[] type = new Class[]{Integer.class, Long.class, Short.class, Date.class};
        this.checkParams(proc, nameInSource, direction, index, type);
    }

    public void testProcedureWithResultSet() throws Exception {
        Procedure proc = this.getProcedure("ConnectorMetadata.TestProc2", 1, CONNECTOR_METADATA_UTILITY);
        TestProcedure.assertEquals(null, (String)proc.getNameInSource());
        String[] nameInSource = new String[]{null};
        ProcedureParameter.Type[] direction = new ProcedureParameter.Type[]{ProcedureParameter.Type.In};
        int[] index = new int[]{1};
        Class[] type = new Class[]{String.class};
        this.checkParams(proc, nameInSource, direction, index, type);
        List rsCols = proc.getResultSet().getColumns();
        TestProcedure.assertEquals((int)2, (int)rsCols.size());
        Column elemID = (Column)rsCols.get(0);
        TestProcedure.assertEquals((String)"RSCol1", (String)elemID.getName());
        TestProcedure.assertEquals((String)"ConnectorMetadata.TestProc2.RSParam.RSCol1", (String)elemID.getFullName());
        TestProcedure.assertEquals((String)"Result set column name in source", (String)elemID.getNameInSource());
        TestProcedure.assertEquals(Timestamp.class, (Object)elemID.getJavaType());
        TestProcedure.assertEquals((int)1, (int)elemID.getPosition());
        Column elemID2 = (Column)rsCols.get(1);
        TestProcedure.assertEquals((String)"RSCol2", (String)elemID2.getName());
        TestProcedure.assertEquals((String)"ConnectorMetadata.TestProc2.RSParam.RSCol2", (String)elemID2.getFullName());
        TestProcedure.assertEquals(null, (String)elemID2.getNameInSource());
        TestProcedure.assertEquals(String.class, (Object)elemID2.getJavaType());
        TestProcedure.assertEquals((int)2, (int)elemID2.getPosition());
        Properties props = new Properties();
        props.put("ColProp", "defaultvalue");
    }

    private List<ProcedureParameter> checkParams(Procedure proc, String[] nameInSource, ProcedureParameter.Type[] direction, int[] index, Class<?>[] type) {
        List params = proc.getParameters();
        TestProcedure.assertEquals((int)type.length, (int)params.size());
        for (int i = 0; i < params.size(); ++i) {
            ProcedureParameter param = (ProcedureParameter)params.get(i);
            TestProcedure.assertEquals((String)nameInSource[i], (String)param.getNameInSource());
            TestProcedure.assertEquals((Object)direction[i], (Object)param.getType());
            TestProcedure.assertEquals((int)index[i], (int)param.getPosition());
            TestProcedure.assertEquals(type[i], (Object)param.getJavaType());
        }
        return params;
    }
}

