/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.client.metadata.ResultsMetadataConstants;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.jdbc.MetadataProvider;

public class TestStaticMetadataProvider
extends TestCase {
    public TestStaticMetadataProvider(String name) {
        super(name);
    }

    private MetadataProvider example1() throws Exception {
        MetaDataProcessor processor = new MetaDataProcessor(null, null, "vdb", 1);
        Map[] columnMetadata = new Map[]{processor.getDefaultColumn("table", "c1", String.class), processor.getDefaultColumn("table", "c2", Integer.class)};
        return new MetadataProvider(columnMetadata);
    }

    public void testMetadata() throws Exception {
        MetadataProvider provider = this.example1();
        TestStaticMetadataProvider.assertEquals((int)2, (int)provider.getColumnCount());
        for (int i = 0; i < provider.getColumnCount(); ++i) {
            TestStaticMetadataProvider.assertNotNull((Object)provider.getValue(i, ResultsMetadataConstants.VIRTUAL_DATABASE_NAME));
            TestStaticMetadataProvider.assertNotNull((Object)provider.getValue(i, ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION));
            TestStaticMetadataProvider.assertNotNull((Object)provider.getValue(i, ResultsMetadataConstants.GROUP_NAME));
            TestStaticMetadataProvider.assertNotNull((Object)provider.getValue(i, ResultsMetadataConstants.ELEMENT_NAME));
        }
    }

    public void testGetStringValue() throws Exception {
        Integer property = ResultsMetadataConstants.VIRTUAL_DATABASE_NAME;
        String value = "vdb";
        HashMap<Integer, String> columnMetadata = new HashMap<Integer, String>();
        columnMetadata.put(property, value);
        MetadataProvider md = new MetadataProvider(new Map[]{columnMetadata});
        String actualValue = md.getStringValue(0, property);
        TestStaticMetadataProvider.assertEquals((String)value, (String)actualValue);
    }

    public void testGetIntValue() throws Exception {
        Integer property = ResultsMetadataConstants.VIRTUAL_DATABASE_NAME;
        Integer value = new Integer(10);
        HashMap<Integer, Integer> columnMetadata = new HashMap<Integer, Integer>();
        columnMetadata.put(property, value);
        MetadataProvider md = new MetadataProvider(new Map[]{columnMetadata});
        int actualValue = md.getIntValue(0, property);
        TestStaticMetadataProvider.assertEquals((int)10, (int)actualValue);
    }

    public void testGetBooleanValue() throws Exception {
        Integer property = ResultsMetadataConstants.VIRTUAL_DATABASE_NAME;
        Boolean value = Boolean.TRUE;
        HashMap<Integer, Boolean> columnMetadata = new HashMap<Integer, Boolean>();
        columnMetadata.put(property, value);
        MetadataProvider md = new MetadataProvider(new Map[]{columnMetadata});
        boolean actualValue = md.getBooleanValue(0, property);
        TestStaticMetadataProvider.assertEquals((boolean)true, (boolean)actualValue);
    }
}

