/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestRestWebserviceGeneration
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testGetOperation() throws Exception {
        this.admin.deploy("sample-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_1.war", 5));
        String response = this.httpCall("http://localhost:8080/sample_1/view/g1/123", "GET", null);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"123\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
    }

    @Test
    public void testPostOperation() throws Exception {
        this.admin.deploy("sample-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"sample-vdb.xml")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "sample", 1, 3));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:sample@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT * FROM Txns.G1");
        this.internalResultSet.next();
        Assert.assertTrue((String)"sample_1.war not found", (boolean)AdminUtil.waitForDeployment(this.admin, "sample_1.war", 5));
        String params = URLEncoder.encode("p1", "UTF-8") + "=" + URLEncoder.encode("456", "UTF-8");
        String response = this.httpCall("http://localhost:8080/sample_1/view/g1post", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows p1=\"456\"><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
        params = URLEncoder.encode("sql", "UTF-8") + "=" + URLEncoder.encode("SELECT XMLELEMENT(NAME \"rows\", XMLAGG(XMLELEMENT(NAME \"row\", XMLFOREST(e1, e2)))) AS xml_out FROM Txns.G1", "UTF-8");
        response = this.httpCall("http://localhost:8080/sample_1/view/query", "POST", params);
        Assert.assertEquals((String)"response did not match expected", (Object)"<rows><row><e1>ABCDEFGHIJ</e1><e2>0</e2></row></rows>", (Object)response);
    }

    private String httpCall(String url, String method, String params) throws Exception {
        String line;
        StringBuffer buff = new StringBuffer();
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(method);
        connection.setDoOutput(true);
        if (method.equalsIgnoreCase("post")) {
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(params);
            wr.flush();
        }
        BufferedReader serverResponse = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while ((line = serverResponse.readLine()) != null) {
            buff.append(line);
        }
        return buff.toString();
    }
}

