/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestODBCProceduresSchema
extends AbstractMMQueryTestCase {
    private static final String VDB = "bqt";
    private static FakeServer server;

    public TestODBCProceduresSchema() {
        this.DELIMITER = "\t";
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/bqt.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() throws Exception {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.internalConnection = server.createConnection("jdbc:teiid:bqt");
    }

    @Test
    public void test_Pg_Proc_alltypes() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='bigProcedure'");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_Pg_Proc_void() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='VoidProcedure'");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_Pg_Proc_with_return() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='ProcedureWithReturn'");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }

    @Test
    public void test_Pg_Proc_with_return_table() throws Exception {
        this.execute("select oid, proname, proretset,prorettype, pronargs, proargtypes, proargnames, proargmodes, proallargtypes, pronamespace FROM pg_proc where proname='ProcedureReturnTable'");
        TestMMDatabaseMetaData.compareResultSet(this.internalResultSet);
    }
}

