/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.Arrays;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestVDBMerge
extends AbstractMMQueryTestCase {
    private static final String VDB1 = "PartsSupplier";
    private static final String VDB2 = "QT_Ora9DS";
    private FakeServer server;

    @Before
    public void setup() throws Exception {
        this.server = new FakeServer(true);
        this.server.setThrowMetadataErrors(false);
    }

    @After
    public void teardown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testMerge() throws Throwable {
        this.server.deployVDB(VDB1, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.execute("select * from tables where schemaname ='PartsSupplier'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.test", this.internalResultSet);
        this.execute("select * from tables where schemaname='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.before", this.internalResultSet);
        this.internalConnection.close();
        this.server.deployVDB(VDB2, UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        FakeServer.DeployVDBParameter param = new FakeServer.DeployVDBParameter(null, null);
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName(VDB2);
        param.vdbImports = Arrays.asList(vdbImport);
        this.server.removeVDB(VDB1);
        this.server.deployVDB(VDB1, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb", param);
        this.internalConnection = this.server.createConnection("jdbc:teiid:PartsSupplier");
        this.execute("select * from tables where schemaname='BQT1' order by name");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/merge.after", this.internalResultSet);
    }

    @Test
    public void testMergeWithEmptyVDB() throws Exception {
        this.server.deployVDB("empty", UnitTestUtil.getTestDataPath() + "/empty.vdb");
        this.internalConnection = this.server.createConnection("jdbc:teiid:empty");
        this.execute("select * from tables where schemaname ='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/mergeEmpty.before", this.internalResultSet);
        this.internalConnection.close();
        this.server.deployVDB(VDB2, UnitTestUtil.getTestDataPath() + "/QT_Ora9DS_1.vdb");
        FakeServer.DeployVDBParameter param = new FakeServer.DeployVDBParameter(null, null);
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName(VDB2);
        param.vdbImports = Arrays.asList(vdbImport);
        this.server.undeployVDB("empty");
        this.server.deployVDB("empty", UnitTestUtil.getTestDataPath() + "/empty.vdb", param);
        this.internalConnection = this.server.createConnection("jdbc:teiid:empty");
        this.execute("select * from tables where schemaname='BQT1'");
        TestMMDatabaseMetaData.compareResultSet("TestVDBMerge/mergeEmpty.after", this.internalResultSet);
    }
}

