/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;

@RunWith(value=Arquillian.class)
public class IntegrationTestOData
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testOdata() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <property name=\"UseConnectorMetadata\" value=\"true\" />\n    <model name=\"MarketData\">\n        <source name=\"text-connector2\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE G1 (e1 string, e2 integer PRIMARY KEY);\n                CREATE FOREIGN TABLE G2 (e1 string, e2 integer PRIMARY KEY) OPTIONS (UPDATABLE 'true');\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("user", "user"));
        GetMethod method = new GetMethod("http://localhost:8080/odata/loopy.1/$metadata");
        int statusCode = client.executeMethod((HttpMethod)method);
        Assert.assertTrue((statusCode == 200 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"loopy-metadata-results.txt")), (Object)method.getResponseBodyAsString());
        method.releaseConnection();
    }
}

