/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.deployers.VDBRepository;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;

public class TestMatViewAliasing {
    private static final String MATVIEWS = "matviews";
    private Connection conn;
    private FakeServer server;

    @Before
    public void setUp() throws Exception {
        this.server = new FakeServer(true);
        VDBRepository vdbRepository = new VDBRepository();
        MetadataFactory mf = new MetadataFactory(null, 1, "foo", vdbRepository.getRuntimeTypeMap(), new Properties(), null);
        mf.getSchema().setPhysical(false);
        Table mat = mf.addTable("mat");
        mat.setVirtual(true);
        mat.setMaterialized(true);
        mat.setSelectTransformation("/*+ cache(ttl:0) */ select 1 as x, 'y' as Name");
        mf.addColumn("x", "integer", (ColumnSet)mat);
        mf.addColumn("Name", "string", (ColumnSet)mat);
        MetadataStore ms = mf.asMetadataStore();
        this.server.deployVDB(MATVIEWS, ms);
        this.conn = this.server.createConnection("jdbc:teiid:matviews");
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop();
        this.conn.close();
    }

    @Test
    public void testSystemMatViewsWithImplicitLoad() throws Exception {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select * from MatViews order by name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"NEEDS_LOADING", (Object)rs.getString("loadstate"));
        Assert.assertEquals((Object)false, (Object)rs.getBoolean("valid"));
        rs = s.executeQuery("select * from mat order by x");
        Assert.assertTrue((boolean)rs.next());
        rs = s.executeQuery("select * from MatViews where name = 'mat'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs.getString("loadstate"));
        rs = s.executeQuery("select * from mat as a, mat as b where a.x = b.name order by a.x");
        Assert.assertFalse((boolean)rs.next());
    }
}

