/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.jboss.AdminFactory;
import org.teiid.arquillian.AdminUtil;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestOData4
extends AbstractMMQueryTestCase {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9990, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    @Test
    public void testOdata() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <model name=\"MarketData\">\n        <source name=\"text-connector2\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE G1 (e1 string, e2 integer PRIMARY KEY);\n                CREATE FOREIGN TABLE G2 (e1 string, e2 integer PRIMARY KEY) OPTIONS (UPDATABLE 'true');\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        WebClient client = WebClient.create((String)"http://localhost:8080/odata4/loopy.1/MarketData/$metadata");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        Response response = client.invoke("GET", null);
        int statusCode = response.getStatus();
        Assert.assertEquals((long)200L, (long)statusCode);
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:loopy@mm://localhost:31000;user=user;password=user", null);
        CallableStatement ps = conn.prepareCall("select t.* from xmltable('/*:Edmx/*:DataServices/*:Schema[@Alias=\"MarketData\"]' passing xmlparse(document cast(? as clob))) as t");
        ps.setAsciiStream(1, (InputStream)response.getEntity());
        ResultSet rs = ps.executeQuery();
        rs.next();
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"loopy-metadata4-results.txt")), (Object)rs.getString(1));
        conn.close();
        client = WebClient.create((String)"http://localhost:8080/odata4/x/y$metadata");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        response = client.invoke("GET", null);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        this.admin.undeploy("loopy-vdb.xml");
    }

    @Test
    public void testReadOdataMetadata() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <model name=\"MarketData\">\n        <source name=\"text-connector2\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE G1 (e1 string[], e2 integer PRIMARY KEY);\n                CREATE FOREIGN TABLE G2 (e1 string, e2 integer PRIMARY KEY) OPTIONS (UPDATABLE 'true');\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        String vdb2 = "<?xml version='1.0' encoding='UTF-8'?>\n<vdb name=\"TestOData\" version=\"1\">\n    <model name=\"TestOData\" type=\"PHYSICAL\" visible=\"true\">\n     <property name=\"importer.entityContainer\" value=\"MarketData\"/>\n     <property name=\"importer.schemaNamespace\" value=\"MarketData\"/>\n     <source name=\"TestOData\" translator-name=\"odata4\" connection-jndi-name=\"java:/TestOData4\"/>\n    </model>\n</vdb>";
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "http://localhost:8080/odata4/Loopy.1/MarketData");
        p.setProperty("SecurityType", "HTTPBasic");
        p.setProperty("AuthUserName", "user");
        p.setProperty("AuthPassword", "user");
        this.admin.createDataSource("TestOData4", "webservice", p);
        this.admin.deploy("test-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb2), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "TestOData", 1, 30000));
        this.internalConnection = TeiidDriver.getInstance().connect("jdbc:teiid:TestOData@mm://localhost:31000;user=user;password=user", null);
        this.execute("SELECT Name FROM Sys.Tables Where name='G1'");
        this.assertResultsSetEquals("Name[string]\nG1");
        this.execute("SELECT * from G1");
        this.assertResultsSetEquals("e1[string[]]    e2[integer]\n[ABCDEFGHIJ]    0");
        this.admin.undeploy("loopy-vdb.xml");
        this.admin.undeploy("test-vdb.xml");
    }

    @Test
    public void testCompositeKeyTimestamp() throws Exception {
        String vdb = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"Loopy\" version=\"1\">\n    <model name=\"m\">\n        <source name=\"x1\" translator-name=\"loopback\" />\n         <metadata type=\"DDL\"><![CDATA[\n                CREATE FOREIGN TABLE x (a string, b timestamp, c integer, primary key (a, b)) options (updatable true);\n        ]]> </metadata>\n    </model>\n</vdb>";
        this.admin.deploy("loopy-vdb.xml", (InputStream)new ReaderInputStream((Reader)new StringReader(vdb), Charset.forName("UTF-8")));
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "Loopy", 1, 3));
        WebClient client = WebClient.create((String)"http://localhost:8080/odata4/Loopy/m/x(a='a',b=2011-09-11T00:00:00Z)");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        Response response = client.invoke("GET", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        client = WebClient.create((String)"http://localhost:8080/odata4/Loopy/m/x");
        client.header("Authorization", new Object[]{"Basic " + Base64.encodeBytes((byte[])"user:user".getBytes())});
        client.header("Content-Type", new Object[]{"application/json"});
        response = client.post((Object)"{\"a\":\"b\", \"b\":\"2000-02-02T22:22:22Z\"}");
        Assert.assertEquals((long)304L, (long)response.getStatus());
        this.admin.undeploy("loopy-vdb.xml");
    }
}

