/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cdk.api;

import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.metadata.Table;

public class TestTranslationUtility
extends TestCase {
    public TestTranslationUtility(String name) {
        super(name);
    }

    public String getTestVDB() {
        return UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb";
    }

    public void helpTestTranslate(String sql, String expectedOutput) {
        TranslationUtility util = new TranslationUtility(this.getTestVDB());
        Command query = util.parseCommand(sql);
        TestTranslationUtility.assertEquals((String)expectedOutput, (String)query.toString());
    }

    public void testQuery1() {
        this.helpTestTranslate("select * from partssupplier.parts", "SELECT PARTS.PART_ID, PARTS.PART_NAME, PARTS.PART_COLOR, PARTS.PART_WEIGHT FROM PARTS");
    }

    public void testInsert1() {
        this.helpTestTranslate("insert into partssupplier.parts (part_name, part_color) values ('P100', 'Red')", "INSERT INTO PARTS (PART_NAME, PART_COLOR) VALUES ('P100', 'Red')");
    }

    public void testUpdate1() {
        this.helpTestTranslate("update partssupplier.parts set part_name = 'P100' where part_color = 'Red'", "UPDATE PARTS SET PART_NAME = 'P100' WHERE PARTS.PART_COLOR = 'Red'");
    }

    public void testDelete1() {
        this.helpTestTranslate("delete from partssupplier.parts where part_color = 'Red'", "DELETE FROM PARTS WHERE PARTS.PART_COLOR = 'Red'");
    }

    public void testGetRMD() throws Exception {
        TranslationUtility util = new TranslationUtility(this.getTestVDB());
        Select query = (Select)util.parseCommand("select * from partssupplier.parts");
        NamedTable group = (NamedTable)query.getFrom().get(0);
        Table mid = group.getMetadataObject();
        TestTranslationUtility.assertEquals((String)"PartsSupplier.PARTSSUPPLIER.PARTS", (String)mid.getFullName());
        TestTranslationUtility.assertEquals((String)"PARTS", (String)mid.getNameInSource());
    }
}

