/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;

public class TestMetadataObject {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestMetadataObject.createTranslationUtility(TestMetadataObject.getTestVDBName());

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Table getGroupID(String groupName, TranslationUtility transUtil) {
        Select query = (Select)transUtil.parseCommand("SELECT 1 FROM " + groupName);
        NamedTable group = (NamedTable)query.getFrom().get(0);
        return group.getMetadataObject();
    }

    public void helpTestGroupID(String fullGroupName, String shortGroupName, int elementCount, TranslationUtility transUtil) throws Exception {
        Table groupID = this.getGroupID(fullGroupName, transUtil);
        Assert.assertEquals((Object)fullGroupName, (Object)groupID.getFullName());
        Assert.assertEquals((Object)shortGroupName, (Object)groupID.getName());
        List children = groupID.getColumns();
        Assert.assertEquals((long)elementCount, (long)children.size());
        for (Column element : children) {
            Assert.assertEquals((Object)groupID, (Object)element.getParent());
            Assert.assertTrue((boolean)element.getFullName().startsWith(groupID.getFullName()));
        }
    }

    @Test
    public void testGroupID() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestTable", "TestTable", 7, CONNECTOR_METADATA_UTILITY);
    }

    @Test
    public void testGroupID_longName() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCatalog.TestSchema.TestTable2", 1, CONNECTOR_METADATA_UTILITY);
    }

    public Column getElementID(String groupName, String elementName, TranslationUtility transUtil) {
        Select query = (Select)transUtil.parseCommand("SELECT " + elementName + " FROM " + groupName);
        DerivedColumn symbol = (DerivedColumn)query.getDerivedColumns().get(0);
        ColumnReference element = (ColumnReference)symbol.getExpression();
        return element.getMetadataObject();
    }

    public void helpTestElementID(String groupName, String elementName, TranslationUtility transUtil) throws Exception {
        Column elementID = this.getElementID(groupName, elementName, transUtil);
        Assert.assertEquals((Object)(groupName + "." + elementName), (Object)elementID.getFullName());
        Assert.assertEquals((Object)elementName, (Object)elementID.getName());
        Assert.assertNotNull((Object)elementID.getParent());
        Assert.assertEquals((Object)groupName, (Object)elementID.getParent().getFullName());
    }

    @Test
    public void testElementID() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestTable", "TestNameInSource", CONNECTOR_METADATA_UTILITY);
    }

    @Test
    public void testElementID_longName() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCol", CONNECTOR_METADATA_UTILITY);
    }

    public Procedure getProcedureID(String procName, int inputParamCount, TranslationUtility transUtil) {
        StringBuffer sql = new StringBuffer("EXEC ");
        sql.append(procName);
        sql.append("(");
        for (int i = 0; i < inputParamCount; ++i) {
            sql.append("null");
            if (i >= inputParamCount - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        Call proc = (Call)transUtil.parseCommand(sql.toString());
        return proc.getMetadataObject();
    }

    public void helpTestProcedureID(String procName, String shortName, int inputParamCount, String[] paramNames, String rsParamName, TranslationUtility transUtil) throws Exception {
        Procedure procID = this.getProcedureID(procName, inputParamCount, transUtil);
        Assert.assertEquals((Object)procName, (Object)procID.getFullName());
        Assert.assertEquals((Object)shortName, (Object)procID.getName());
        List children = procID.getParameters();
        int i = 0;
        for (ProcedureParameter childID : children) {
            Assert.assertEquals((Object)procID, (Object)childID.getParent());
            Assert.assertTrue((String)(childID.getFullName() + " " + procID.getFullName()), (boolean)childID.getFullName().startsWith(procID.getFullName()));
            Assert.assertEquals((Object)paramNames[i++], (Object)childID.getName());
        }
        if (rsParamName != null) {
            Assert.assertEquals((Object)rsParamName, (Object)procID.getResultSet().getName());
        } else {
            Assert.assertNull((Object)procID.getResultSet());
        }
    }

    @Test
    public void testProcedureID() throws Exception {
        String[] paramNames = new String[]{"InParam", "OutParam", "InOutParam", "ReturnParam"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc1", "TestProc1", 2, paramNames, null, CONNECTOR_METADATA_UTILITY);
    }

    @Test
    public void testProcedureID_resultSet() throws Exception {
        String[] paramNames = new String[]{"Param1"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc2", "TestProc2", 1, paramNames, "RSParam", CONNECTOR_METADATA_UTILITY);
    }

    @Test
    public void testProcedureID_longName() throws Exception {
        this.helpTestProcedureID("ConnectorMetadata.TestCatalog.TestSchema.TestProc", "TestCatalog.TestSchema.TestProc", 0, new String[0], null, CONNECTOR_METADATA_UTILITY);
    }
}

