/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;

public class TestPGMetadata
extends AbstractMMQueryTestCase {
    static FakeServer server = null;

    @BeforeClass
    public static void setup() {
        server = new FakeServer(true);
    }

    @AfterClass
    public static void teardown() {
        server.stop();
    }

    private static VDBMetaData buildVDB(String name) {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName(name);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.addSourceMetadata("DDL", "create view v as select 1");
        mmd.setModelType(Model.Type.VIRTUAL);
        vdb.addModel(mmd);
        return vdb;
    }

    @Test
    public void test_PG_MetadataOFF() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("x");
        vdb.addProperty("include-pg-metadata", "false");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:x");
        try {
            this.execute("select * FROM pg_am");
            Assert.fail((String)"there should be no PG metadata");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test_PG_Metadata_ON() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("y");
        vdb.addProperty("include-pg-metadata", "true");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:y");
        this.execute("select * FROM pg_am");
    }

    @Test
    public void test_PG_Metadata_DEFAULT() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("z");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:z");
        this.execute("select * FROM pg_am");
    }

    @Test
    public void testTypes() throws Exception {
        VDBMetaData vdb = TestPGMetadata.buildVDB("t");
        server.deployVDB(vdb);
        this.internalConnection = server.createConnection("jdbc:teiid:t");
        this.execute("select format_type((select oid from pg_type where typname = '_int2'), 0)");
        this.assertResults(new String[]{"expr1[string]", "smallint[]"});
        this.execute("select format_type((select oid from pg_type where typname = 'float4'), 0)");
        this.assertResults(new String[]{"expr1[string]", "real"});
        this.execute("select format_type((select oid from pg_type where typname = 'numeric'), 100)");
        this.assertResults(new String[]{"expr1[string]", "numeric(0,96)"});
    }
}

