/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.jdbc.AbstractQueryTest;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.HardCodedExecutionFactory;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class TestSystemPerformance
extends AbstractQueryTest {
    private static final int TABLES = 2000;
    private static final int COLS = 16;
    EmbeddedServer es;

    @Before
    public void setup() throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException {
        this.es = new EmbeddedServer();
        this.es.start(new EmbeddedConfiguration());
        ModelMetaData mmm = new ModelMetaData();
        mmm.setName("test");
        mmm.setSchemaSourceType("native");
        mmm.addSourceMapping("x", "hardcoded", null);
        HardCodedExecutionFactory hardCodedExecutionFactory = new HardCodedExecutionFactory(){

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                int i;
                String[] colNames = new String[16];
                for (i = 0; i < colNames.length; ++i) {
                    colNames[i] = "col" + i;
                }
                for (i = 0; i < 2000; ++i) {
                    Table t = metadataFactory.addTable("x" + i);
                    for (int j = 0; j < 16; ++j) {
                        metadataFactory.addColumn(colNames[j], "string", (ColumnSet)t);
                    }
                }
            }

            public boolean isSourceRequiredForMetadata() {
                return false;
            }
        };
        this.es.addTranslator((ExecutionFactory)hardCodedExecutionFactory);
        this.es.deployVDB("test", new ModelMetaData[]{mmm});
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    @Test
    public void testColumnPerformance() throws Exception {
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        this.setConnection((Connection)c);
        DatabaseMetaData metadata = c.getMetaData();
        System.out.println("starting");
        for (int i = 0; i < 2000; ++i) {
            this.internalResultSet = metadata.getColumns(null, "test", "x" + i, null);
            this.assertRowCount(16);
            this.internalResultSet.close();
        }
    }
}

