/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.client.BatchSerializer;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.AccessibleByteArrayOutputStream;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.TestTextTable;
import org.teiid.query.processor.relational.BlockingFakeRelationalNode;
import org.teiid.query.processor.relational.EnhancedSortMergeJoinStrategy;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.JoinStrategy;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

@FixMethodOrder(value=MethodSorters.JVM)
public class TestEnginePerformance {
    private static boolean debug = false;
    private static BufferManagerImpl bm;
    private static BufferFrontedFileStoreCache cache;
    private static ExecutorService es;
    private static Random r;

    private void runTask(final int iterations, int threadCount, Task task) throws InterruptedException, Exception {
        ArrayList<1> tasks = new ArrayList<1>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            final Task threadTask = task.clone();
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int j = 0; j < iterations; ++j) {
                        threadTask.call();
                    }
                    return null;
                }
            });
        }
        List result = es.invokeAll(tasks);
        for (Future future : result) {
            future.get();
        }
    }

    private void process(RelationalNode node, int expectedRows) throws TeiidComponentException, TeiidProcessingException {
        node.open();
        int currentRow = 1;
        while (true) {
            try {
                TupleBatch batch;
                do {
                    batch = node.nextBatch();
                    currentRow += batch.getRowCount();
                } while (!batch.getTerminationFlag());
            }
            catch (BlockedException blockedException) {
                continue;
            }
            break;
        }
        Assert.assertEquals((long)expectedRows, (long)(currentRow - 1));
        node.close();
    }

    public void helpTestSort(final BufferManager bufferManager, final int rowCount, int iterations, int threadCount, final SortUtility.Mode mode) throws Exception {
        final List[] data = TestEnginePerformance.sampleData(rowCount);
        ElementSymbol elem1 = new ElementSymbol("e1");
        elem1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol elem2 = new ElementSymbol("e2");
        elem2.setType(DataTypeManager.DefaultDataClasses.STRING);
        final List<ElementSymbol> sortElements = Arrays.asList(elem1);
        final List<ElementSymbol> elems = Arrays.asList(elem1, elem2);
        Task task = new Task(){

            @Override
            public Void call() throws Exception {
                TestEnginePerformance.this.helpTestSort(mode, rowCount, sortElements, data, elems, bufferManager);
                return null;
            }
        };
        this.runTask(iterations, threadCount, task);
    }

    static List<?>[] sampleData(int rowCount) {
        List[] data = new List[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            data[i] = Arrays.asList(i, String.valueOf(i));
        }
        Collections.shuffle(Arrays.asList(data), r);
        return data;
    }

    public void helpTestSort(SortUtility.Mode mode, int expectedRowCount, List<? extends Expression> sortElements, List<?>[] data, List<? extends Expression> elems, BufferManager bufferManager) throws TeiidComponentException, TeiidProcessingException {
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, (Object)1);
        BlockingFakeRelationalNode dataNode = new BlockingFakeRelationalNode(0, (List[])data);
        dataNode.setReturnPeriod(3);
        dataNode.setElements(elems);
        dataNode.initialize(context, bufferManager, null);
        SortNode sortNode = new SortNode(1);
        sortNode.setSortElements(new OrderBy(sortElements).getOrderByItems());
        sortNode.setMode(mode);
        sortNode.setElements(dataNode.getElements());
        sortNode.addChild((RelationalNode)dataNode);
        sortNode.initialize(context, bufferManager, null);
        this.process((RelationalNode)sortNode, expectedRowCount);
    }

    public void helpTestEquiJoin(int expectedRowCount, List<?>[] leftData, List<?>[] rightData, List<? extends Expression> elems, BufferManager bufferManager, JoinStrategy joinStrategy, JoinType joinType) throws TeiidComponentException, TeiidProcessingException {
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, (Object)1);
        FakeRelationalNode dataNode1 = new FakeRelationalNode(1, (List[])leftData);
        dataNode1.setElements(elems);
        dataNode1.initialize(context, bufferManager, null);
        FakeRelationalNode dataNode2 = new FakeRelationalNode(2, (List[])rightData);
        dataNode2.setElements(elems);
        dataNode2.initialize(context, bufferManager, null);
        JoinNode join = new JoinNode(3);
        join.addChild((RelationalNode)dataNode1);
        join.addChild((RelationalNode)dataNode2);
        join.setJoinStrategy(joinStrategy.clone());
        join.setElements(elems);
        join.setJoinType(joinType);
        join.setJoinExpressions(elems.subList(0, 1), elems.subList(0, 1));
        join.initialize(context, bufferManager, null);
        this.process((RelationalNode)join, expectedRowCount);
    }

    public void helpTestEquiJoin(final BufferManager bufferManager, int leftRowCount, int rightRowCount, int iterations, int threadCount, final JoinStrategy joinStrategy, final JoinType joinType, final int expectedRowCount) throws Exception {
        final List[] leftData = TestEnginePerformance.sampleData(leftRowCount);
        final List[] rightData = TestEnginePerformance.sampleData(rightRowCount);
        ElementSymbol elem1 = new ElementSymbol("e1");
        elem1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol elem2 = new ElementSymbol("e2");
        elem2.setType(DataTypeManager.DefaultDataClasses.STRING);
        final List<ElementSymbol> elems = Arrays.asList(elem1, elem2);
        Task task = new Task(){

            @Override
            public Void call() throws Exception {
                TestEnginePerformance.this.helpTestEquiJoin(expectedRowCount, leftData, rightData, elems, bufferManager, joinStrategy, joinType);
                return null;
            }
        };
        this.runTask(iterations, threadCount, task);
    }

    @BeforeClass
    public static void oneTimeSetup() throws TeiidComponentException {
        bm = new BufferManagerImpl();
        bm.setMaxProcessingKB(4096);
        bm.setMaxReserveKB(196608);
        bm.setMaxActivePlans(20);
        cache = new BufferFrontedFileStoreCache();
        cache.setMemoryBufferSpace(0x4000000L);
        FileStorageManager fsm = new FileStorageManager();
        fsm.setStorageDirectory(UnitTestUtil.getTestScratchPath() + "/data");
        cache.setStorageManager((StorageManager)fsm);
        cache.initialize();
        bm.setCache((Cache)cache);
        bm.initialize();
        es = Executors.newCachedThreadPool();
    }

    @After
    public void tearDown() throws Exception {
        if (debug) {
            TestEnginePerformance.showStats();
        }
    }

    private void helpTestXMLTable(int iterations, int threadCount, String file, int expectedRowCount) throws QueryParserException, TeiidException, InterruptedException, Exception {
        String sql = "select * from xmltable('/root/child' passing xmlparse(document cast(? as clob) wellformed) columns x integer path '@id', y long path 'gc2') as x";
        List<ClobType> preparedValues = Arrays.asList(TestTextTable.clobFromFile((String)file));
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        DefaultCapabilitiesFinder capFinder = new DefaultCapabilitiesFinder();
        ProcessorPlan plan = TestProcessor.helpGetPlan((Command)command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (CommandContext)TestProcessor.createCommandContext());
        this.runTask(iterations, threadCount, new PreparedPlanTask(preparedValues, (QueryMetadataInterface)metadata, plan, command, expectedRowCount));
    }

    private void processPreparedPlan(List<?> values, Command command, QueryMetadataInterface metadata, ProcessorDataManager dataManager, ProcessorPlan plan, int rowCount) throws Exception {
        CommandContext context = TestProcessor.createCommandContext();
        context.setMetadata(metadata);
        context.setExecutor((Executor)es);
        context.setBufferManager((BufferManager)bm);
        TestProcessor.setParameterValues(values, (Command)command, (CommandContext)context);
        plan.reset();
        Assert.assertEquals((long)rowCount, (long)TestProcessor.doProcess((ProcessorPlan)plan, (ProcessorDataManager)dataManager, null, (CommandContext)context));
    }

    @Test
    public void runSort_1_100() throws Exception {
        this.helpTestSort((BufferManager)bm, 100, 20000, 1, SortUtility.Mode.SORT);
    }

    @Test
    public void runSort_4_5000() throws Exception {
        this.helpTestSort((BufferManager)bm, 5000, 1000, 4, SortUtility.Mode.SORT);
    }

    @Test
    public void runSort_16_250000() throws Exception {
        this.helpTestSort((BufferManager)bm, 250000, 10, 16, SortUtility.Mode.SORT);
    }

    @Test
    public void runDupRemove_1_100() throws Exception {
        this.helpTestSort((BufferManager)bm, 100, 20000, 1, SortUtility.Mode.DUP_REMOVE);
    }

    @Test
    public void runDupRemove_4_5000() throws Exception {
        this.helpTestSort((BufferManager)bm, 5000, 1000, 4, SortUtility.Mode.DUP_REMOVE);
    }

    @Test
    public void runDupRemove_16_250000() throws Exception {
        this.helpTestSort((BufferManager)bm, 250000, 10, 16, SortUtility.Mode.DUP_REMOVE);
    }

    @Test
    public void runInnerEnhancedJoin_1_100_500() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 100, 500, 10000, 1, (JoinStrategy)new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT), JoinType.JOIN_INNER, 100);
    }

    @Test
    public void runInnerEnhancedJoin_4_200_15000() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 200, 15000, 500, 4, (JoinStrategy)new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT), JoinType.JOIN_INNER, 200);
    }

    @Test
    public void runInnerEnhancedJoin_16_400_500000() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 400, 500000, 10, 16, (JoinStrategy)new EnhancedSortMergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT), JoinType.JOIN_INNER, 400);
    }

    @Test
    public void runInnerMergeJoin_1_100_100() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 100, 100, 10000, 1, (JoinStrategy)new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT, false), JoinType.JOIN_INNER, 100);
    }

    @Test
    public void runOuterMergeJoin_1_1000_1000() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 1000, 1000, 10000, 1, (JoinStrategy)new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT, false), JoinType.JOIN_FULL_OUTER, 1000);
    }

    @Test
    public void runInnerMergeJoin_4_4000_4000() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 4000, 4000, 500, 4, (JoinStrategy)new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT, false), JoinType.JOIN_INNER, 4000);
    }

    @Test
    public void runInnerMergeJoin_16_100000_100000() throws Exception {
        this.helpTestEquiJoin((BufferManager)bm, 100000, 100000, 10, 16, (JoinStrategy)new MergeJoinStrategy(MergeJoinStrategy.SortOption.SORT, MergeJoinStrategy.SortOption.SORT, false), JoinType.JOIN_INNER, 100000);
    }

    @Test
    public void runXMLTable_1_5mb() throws Exception {
        this.helpTestXMLTable(25, 1, "test.xml", 50000);
    }

    @Test
    public void runXMLTable_4_5mb() throws Exception {
        this.helpTestXMLTable(10, 4, "test.xml", 50000);
    }

    @Test
    public void runXMLTable_16_5mb() throws Exception {
        this.helpTestXMLTable(4, 16, "test.xml", 50000);
    }

    @Test
    public void runLike_1() throws Exception {
        this.helpTestLike(200000, 1);
    }

    @Test
    public void runLike_4() throws Exception {
        this.helpTestLike(100000, 4);
    }

    @Test
    public void runLike_16() throws Exception {
        this.helpTestLike(50000, 16);
    }

    @Test
    public void runBatchSerialization_String() throws Exception {
        String[] types = new String[]{"string"};
        int size = 1024;
        ArrayList batch = new ArrayList();
        for (int i = 0; i < size; ++i) {
            batch.add(Arrays.asList(String.valueOf(i)));
        }
        this.helpTestBatchSerialization(types, batch, 50000, 2);
    }

    @Test
    public void runBatchSerialization_StringRepeated() throws Exception {
        String[] types = new String[]{"string"};
        int size = 1024;
        ArrayList batch = new ArrayList();
        for (int i = 0; i < size; ++i) {
            batch.add(Arrays.asList("aaaaaaaa"));
        }
        this.helpTestBatchSerialization(types, batch, 50000, 2);
    }

    @Test
    public void runBatchSerialization_Time() throws Exception {
        String[] types = new String[]{"time"};
        int size = 1024;
        ArrayList batch = new ArrayList();
        for (int i = 0; i < size; ++i) {
            batch.add(Arrays.asList(new Time(i)));
        }
        this.helpTestBatchSerialization(types, batch, 50000, 2);
    }

    @Test
    public void runBatchSerialization_Date() throws Exception {
        String[] types = new String[]{"date"};
        int size = 1024;
        ArrayList batch = new ArrayList();
        for (int i = 0; i < size; ++i) {
            batch.add(Arrays.asList(new Date(i)));
        }
        this.helpTestBatchSerialization(types, batch, 50000, 2);
    }

    private void helpTestBatchSerialization(final String[] types, final List<List<?>> batch, int iterations, int threadCount) throws InterruptedException, Exception {
        this.runTask(iterations, threadCount, new Task(){

            @Override
            public Void call() throws Exception {
                TestEnginePerformance.this.writeReadBatch(types, batch);
                return null;
            }
        });
    }

    private List<List<Object>> writeReadBatch(String[] types, List<List<?>> batch) throws IOException, ClassNotFoundException {
        AccessibleByteArrayOutputStream baos = new AccessibleByteArrayOutputStream(5000);
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)baos);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])types, batch);
        out.flush();
        byte[] bytes = baos.getBuffer();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes, 0, baos.getCount());
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        List newBatch = BatchSerializer.readBatch((ObjectInput)in, (String[])types);
        out.close();
        in.close();
        Assert.assertEquals((long)batch.size(), (long)newBatch.size());
        return newBatch;
    }

    private void helpTestLike(int iterations, int threads) throws QueryParserException, InterruptedException, Exception {
        final Expression ex = QueryParser.getQueryParser().parseExpression("'abcdefg' like 'a%g'");
        this.runTask(iterations, threads, new Task(){

            @Override
            public Void call() throws Exception {
                Evaluator.evaluate((Expression)ex);
                return null;
            }
        });
    }

    private void helpTestLargeSort(int iterations, int threads, final int rows) throws InterruptedException, Exception {
        final ArrayList<ElementSymbol> elems = new ArrayList<ElementSymbol>();
        int cols = 50;
        for (int i = 0; i < 50; ++i) {
            ElementSymbol elem1 = new ElementSymbol("e" + i);
            elem1.setType(DataTypeManager.DefaultDataClasses.STRING);
            elems.add(elem1);
        }
        final List<ElementSymbol> sortElements = Arrays.asList((ElementSymbol)elems.get(0));
        Task task = new Task(){

            @Override
            public Void call() throws Exception {
                CommandContext context = new CommandContext((Object)"pid", "test", null, null, (Object)1);
                SortNode sortNode = new SortNode(1);
                sortNode.setSortElements(new OrderBy(sortElements).getOrderByItems());
                sortNode.setMode(SortUtility.Mode.SORT);
                sortNode.setElements(elems);
                RelationalNode rn = new RelationalNode(2){
                    int blockingPeriod;
                    int count;
                    int batches;
                    {
                        this.blockingPeriod = 3;
                        this.count = 0;
                        this.batches = 0;
                    }

                    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
                        int start;
                        int batchSize;
                        if (this.count++ % this.blockingPeriod == 0) {
                            throw BlockedException.INSTANCE;
                        }
                        int batchRows = batchSize = this.getBatchSize();
                        boolean done = false;
                        if ((start = this.batches++ * batchSize) + batchSize >= rows) {
                            done = true;
                            batchRows = rows - start;
                        }
                        ArrayList batch = new ArrayList(batchRows);
                        for (int i = 0; i < batchRows; ++i) {
                            ArrayList<String> row = new ArrayList<String>();
                            for (int j = 0; j < 50; ++j) {
                                if (j == 0) {
                                    row.add(String.valueOf((long)(i * 279470273) % 0xFFFFFFFBL));
                                    continue;
                                }
                                row.add(i + "abcdefghijklmnop" + j);
                            }
                            batch.add(row);
                        }
                        TupleBatch result = new TupleBatch((long)(start + 1), batch);
                        if (done) {
                            result.setTerminationFlag(true);
                        }
                        return result;
                    }

                    public Object clone() {
                        return null;
                    }
                };
                rn.setElements(elems);
                sortNode.addChild(rn);
                sortNode.initialize(context, (BufferManager)bm, null);
                rn.initialize(context, (BufferManager)bm, null);
                TestEnginePerformance.this.process((RelationalNode)sortNode, rows);
                return null;
            }
        };
        this.runTask(iterations, threads, task);
    }

    @Test
    public void runWideSort_1_100000() throws Exception {
        this.helpTestLargeSort(4, 1, 100000);
    }

    @Test
    public void runWideSort_1_500000() throws Exception {
        this.helpTestLargeSort(1, 1, 500000);
    }

    @Test
    public void runWideSort_4_100000() throws Exception {
        this.helpTestLargeSort(2, 4, 100000);
    }

    private static void showStats() {
        System.out.println(bm.getBatchesAdded());
        System.out.println(bm.getReferenceHits());
        System.out.println(bm.getReadAttempts());
        System.out.println(bm.getReadCount());
        System.out.println(bm.getWriteCount());
        System.out.println(cache.getStorageReads());
        System.out.println(cache.getStorageWrites());
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fos = new FileOutputStream(UnitTestUtil.getTestDataFile((String)"test.xml"));
        XMLOutputFactory xof = XMLOutputFactory.newFactory();
        XMLStreamWriter xsw = xof.createXMLStreamWriter(fos);
        xsw.writeStartDocument();
        xsw.writeStartElement("root");
        for (int i = 0; i < 50000; ++i) {
            xsw.writeStartElement("child");
            xsw.writeAttribute("id", String.valueOf(i));
            xsw.writeStartElement("gc1");
            xsw.writeCharacters(String.valueOf(r.nextLong()));
            xsw.writeEndElement();
            xsw.writeStartElement("gc2");
            xsw.writeCharacters(String.valueOf(r.nextLong()));
            xsw.writeEndElement();
            xsw.writeStartElement("gc3");
            xsw.writeCharacters(String.valueOf(r.nextLong()));
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeEndDocument();
        xsw.close();
        fos.close();
    }

    static {
        r = new Random(0L);
    }

    abstract class Task
    implements Callable<Void> {
        Task() {
        }

        public Task clone() {
            return this;
        }
    }

    private final class PreparedPlanTask
    extends Task {
        private final List<?> preparedValues;
        private final QueryMetadataInterface metadata;
        private final ProcessorPlan plan;
        private final Command command;
        private final int rowCount;
        ProcessorDataManager dataManager = new FakeDataManager();

        private PreparedPlanTask(List<?> preparedValues, QueryMetadataInterface metadata, ProcessorPlan plan, Command command, int rowCount) {
            this.preparedValues = preparedValues;
            this.metadata = metadata;
            this.plan = plan;
            this.command = command;
            this.rowCount = rowCount;
        }

        @Override
        public Void call() throws Exception {
            TestEnginePerformance.this.processPreparedPlan(this.preparedValues, this.command, this.metadata, this.dataManager, this.plan, this.rowCount);
            return null;
        }

        @Override
        public Task clone() {
            return new PreparedPlanTask(this.preparedValues, this.metadata, this.plan.clone(), this.command, this.rowCount);
        }
    }
}

