/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.sizing;

public class Caculation {
    private int source_count;
    private int queries_concurrent;
    private int queries_per_sec;
    private int row_count_each;
    private int row_size_each;
    private int avg_time_each;
    private int row_count_federated;
    private int row_size_federated;
    private int avg_time_sample;
    private boolean isAggregation;

    public int heapCaculation() {
        int sources = this.getSource_count();
        int concurrent = this.getQueries_concurrent();
        int total_in_mb = concurrent * 5 * sources + 300;
        int heap = total_in_mb / 1024 + 1;
        return heap;
    }

    public int coreCaculation() {
        int sources = this.getSource_count();
        int row_count_each = this.getRow_count_each();
        int row_size_each = this.getRow_size_each();
        int source_latency = this.getAvg_time_each();
        int row_count_federdated = this.getRow_count_federated();
        int row_size_federdated = this.getRow_size_federated();
        int walltime = this.getAvg_time_sample();
        boolean isAggregation = this.isAggregation();
        int queries_per_sec = this.getQueries_per_sec();
        long source_processing = this.getSourceProcessingTime(row_count_each, row_size_each, sources);
        long initial_latency = this.getInitialLatency(row_count_each, row_size_each, sources, source_latency);
        long additional_latency = this.getAdditionalLatency(sources, source_latency);
        long client_processing = this.getClientProcessing(row_count_federdated, row_size_federdated);
        long engine_time = this.getEngineTime(isAggregation, sources, row_count_each, row_size_each, row_size_federdated, row_count_federdated, walltime, source_latency);
        long cores = this.getcorenumbers(source_latency, sources, source_processing, initial_latency, additional_latency, engine_time, client_processing, queries_per_sec);
        return (int)cores;
    }

    public long getcorenumbers(int source_latency, int sources, long source_processing, long initial_latency, long additional_latency, long engine_time, long client_processing, int queries_per_sec) {
        double cpu_time = source_processing + engine_time + client_processing;
        double wall_time = cpu_time + (double)initial_latency + (double)additional_latency;
        double cpu_utilization_per_query = cpu_time / wall_time;
        int threads_used_per_query = sources + 1;
        double cores = cpu_time * (double)queries_per_sec * cpu_utilization_per_query * (double)threads_used_per_query / 2000.0;
        return Math.round(cores);
    }

    public long getEngineTime(boolean isAggregation, int sources, int row_count_each, int row_size_each, int row_size_federdated, int row_count_federdated, int walltime, int source_latency) {
        long serializing_time = this.getSourceProcessingTime(row_count_each, row_size_each, sources);
        long deserializing_time = this.getClientProcessing(row_count_federdated, row_size_federdated);
        long initial_latency = this.getInitialLatency(row_count_each, row_size_each, sources, source_latency);
        long additional_latency = this.getAdditionalLatency(sources, source_latency);
        double engine_time = 0.0;
        double engine_time_rough = (long)walltime - serializing_time - deserializing_time - initial_latency - additional_latency;
        long total_fer_size = row_size_federdated * row_count_federdated;
        engine_time = engine_time_rough <= 10.0 ? 10.0 : (isAggregation && total_fer_size > 100000000L ? engine_time_rough * 0.9 : (isAggregation ? engine_time_rough * 0.6 : engine_time_rough * 0.3));
        return Math.round(engine_time);
    }

    public long getClientProcessing(int row_count_federdated, int row_size_federdated) {
        double total_byte = row_count_federdated * row_size_federdated;
        double client_procesing = 0.0;
        if (total_byte > 1.0E7) {
            double size_in_mb = total_byte / 1000000.0;
            client_procesing = 210.0 + 4.6 * size_in_mb;
        } else if (total_byte > 1000000.0 && total_byte <= 1.0E7) {
            double percentage = 1.388888888888889E-5;
            client_procesing = percentage * (total_byte - 1000000.0) + 85.0;
        } else if (total_byte > 100000.0 && total_byte <= 1000000.0) {
            double percentage = 8.333333333333333E-5;
            client_procesing = percentage * (total_byte - 100000.0) + 10.0;
        } else if (total_byte > 10000.0 && total_byte <= 100000.0) {
            double percentage = 5.555555555555556E-5;
            client_procesing = percentage * (total_byte - 10000.0) + 5.0;
        } else if (total_byte > 1000.0 && total_byte <= 10000.0) {
            double percentage = 2.2222222222222223E-4;
            client_procesing = percentage * (total_byte - 1000.0) + 3.0;
        } else if (total_byte > 0.0 && total_byte <= 1000.0) {
            double percentage = 0.002;
            client_procesing = percentage * total_byte;
        } else if (total_byte == 0.0) {
            client_procesing = 0.0;
        }
        return Math.round(client_procesing);
    }

    public long getAdditionalLatency(int sources, int source_latency) {
        double additional_latency = 0.0;
        additional_latency = sources == 1 ? (double)source_latency * 0.5 : (double)source_latency * 0.4;
        return Math.round(additional_latency);
    }

    public long getInitialLatency(int row_count_each, int row_size_each, int sources, int source_latency) {
        long total_byte = row_count_each * row_size_each;
        double initial_latency = 0.0;
        initial_latency = sources == 1 ? (double)source_latency : (total_byte > 100000000L ? (double)source_latency * 0.8 : (double)source_latency * 0.6);
        return Math.round(initial_latency);
    }

    private long getSourceProcessingTime(int row_count_each, int row_size_each, int sources) {
        double total_byte = row_count_each * row_size_each * sources;
        double source_processing = 0.0;
        if (total_byte > 1000000.0) {
            double size_in_mb = total_byte / 1000000.0;
            source_processing = 100.0 + 4.6 * size_in_mb;
        } else if (total_byte > 100000.0 && total_byte <= 1000000.0) {
            double percentage = 8.888888888888889E-5;
            source_processing = percentage * (total_byte - 100000.0) + 20.0;
        } else if (total_byte > 10000.0 && total_byte <= 100000.0) {
            double percentage = 2.0E-4;
            source_processing = percentage * (total_byte - 10000.0) + 2.0;
        } else {
            source_processing = 0.0;
        }
        return Math.round(source_processing);
    }

    public Caculation(int source_count, int queries_concurrent) {
        this.source_count = source_count;
        this.queries_concurrent = queries_concurrent;
    }

    public Caculation(int source_count, int queries_concurrent, int queries_per_sec, int row_count_each, int row_size_each, int avg_time_each, int row_count_federated, int row_size_federated, int avg_time_sample, boolean isAggregation) {
        this.source_count = source_count;
        this.queries_concurrent = queries_concurrent;
        this.queries_per_sec = queries_per_sec;
        this.row_count_each = row_count_each;
        this.row_size_each = row_size_each;
        this.avg_time_each = avg_time_each;
        this.row_count_federated = row_count_federated;
        this.row_size_federated = row_size_federated;
        this.avg_time_sample = avg_time_sample;
        this.isAggregation = isAggregation;
    }

    public int getSource_count() {
        return this.source_count;
    }

    public void setSource_count(int source_count) {
        this.source_count = source_count;
    }

    public int getQueries_concurrent() {
        return this.queries_concurrent;
    }

    public void setQueries_concurrent(int queries_concurrent) {
        this.queries_concurrent = queries_concurrent;
    }

    public int getQueries_per_sec() {
        return this.queries_per_sec;
    }

    public void setQueries_per_sec(int queries_per_sec) {
        this.queries_per_sec = queries_per_sec;
    }

    public int getRow_count_each() {
        return this.row_count_each;
    }

    public void setRow_count_each(int row_count_each) {
        this.row_count_each = row_count_each;
    }

    public int getRow_size_each() {
        return this.row_size_each;
    }

    public void setRow_size_each(int row_size_each) {
        this.row_size_each = row_size_each;
    }

    public int getAvg_time_each() {
        return this.avg_time_each;
    }

    public void setAvg_time_each(int avg_time_each) {
        this.avg_time_each = avg_time_each;
    }

    public int getRow_count_federated() {
        return this.row_count_federated;
    }

    public void setRow_count_federated(int row_count_federated) {
        this.row_count_federated = row_count_federated;
    }

    public int getRow_size_federated() {
        return this.row_size_federated;
    }

    public void setRow_size_federated(int row_size_federated) {
        this.row_size_federated = row_size_federated;
    }

    public int getAvg_time_sample() {
        return this.avg_time_sample;
    }

    public void setAvg_time_sample(int avg_time_sample) {
        this.avg_time_sample = avg_time_sample;
    }

    public boolean isAggregation() {
        return this.isAggregation;
    }

    public void setAggregation(boolean isAggregation) {
        this.isAggregation = isAggregation;
    }
}

