/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.sql.Connection;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.jdbc.AbstractQueryTest;
import org.teiid.query.eval.TestEnginePerformance;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;

public class TestMaterializationPerformance
extends AbstractQueryTest {
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
        this.es.start(new EmbeddedConfiguration());
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    @Test
    public void testIndexPerformance() throws Exception {
        ModelMetaData mmm = new ModelMetaData();
        mmm.setName("test");
        mmm.setSchemaSourceType("ddl");
        mmm.setSchemaText("create foreign table x (col1 integer, col2 string); create view matx (col1 integer, col2 string, constraint idx index (col2)) options (materialized true) as select * from x;");
        mmm.addSourceMapping("x", "hc", null);
        HardCodedExecutionFactory hardCodedExecutionFactory = new HardCodedExecutionFactory();
        hardCodedExecutionFactory.addData("SELECT x.col1, x.col2 FROM x", Arrays.asList(TestEnginePerformance.sampleData(10000)));
        this.es.addTranslator("hc", (ExecutionFactory)hardCodedExecutionFactory);
        this.es.deployVDB("test", new ModelMetaData[]{mmm});
        this.setConnection((Connection)this.es.getDriver().connect("jdbc:teiid:test", null));
        for (int i = 0; i < 10000; ++i) {
            this.execute("SELECT * from matx where col2 = ?", new Object[]{String.valueOf(i)});
            Assert.assertEquals((String)String.valueOf(i), (long)this.getRowCount(), (long)1L);
        }
    }

    @Test
    public void testFunctionBasedIndexPerformance() throws Exception {
        ModelMetaData mmm = new ModelMetaData();
        mmm.setName("test");
        mmm.setSchemaSourceType("ddl");
        mmm.setSchemaText("create foreign table x (col1 integer, col2 string); create view matx (col1 integer, col2 string, constraint idx index (upper(col2))) options (materialized true) as select * from x;");
        mmm.addSourceMapping("x", "hc", null);
        HardCodedExecutionFactory hardCodedExecutionFactory = new HardCodedExecutionFactory();
        hardCodedExecutionFactory.addData("SELECT x.col1, x.col2 FROM x", Arrays.asList(TestEnginePerformance.sampleData(10000)));
        this.es.addTranslator("hc", (ExecutionFactory)hardCodedExecutionFactory);
        this.es.deployVDB("test", new ModelMetaData[]{mmm});
        this.setConnection((Connection)this.es.getDriver().connect("jdbc:teiid:test", null));
        for (int i = 0; i < 10000; ++i) {
            this.execute("SELECT * from matx where upper(col2) = ?", new Object[]{String.valueOf(i)});
            Assert.assertEquals((String)String.valueOf(i), (long)this.getRowCount(), (long)1L);
        }
    }
}

