/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.net.InetSocketAddress;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.language.QueryExpression;
import org.teiid.query.processor.TestTextTable;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class TestJDBCSocketPerformance {
    static InetSocketAddress addr;
    static SocketListener jdbcTransport;
    static FakeServer server;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        SocketConfiguration config = new SocketConfiguration();
        config.setSSLConfiguration(new SSLConfiguration());
        addr = new InetSocketAddress(0);
        config.setBindAddress(addr.getHostName());
        config.setPortNumber(0);
        EmbeddedConfiguration dqpConfig = new EmbeddedConfiguration();
        server = new FakeServer(false);
        server.start(dqpConfig);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.PHYSICAL);
        mmd.addSourceMapping("x", "hc", null);
        mmd.setSchemaSourceType("ddl");
        StringBuffer ddl = new StringBuffer("create foreign table x (col0 string");
        for (int i = 1; i < 10; ++i) {
            ddl.append(",").append(" col").append(i).append(" string");
        }
        ddl.append(");");
        mmd.setSchemaText(ddl.toString());
        server.addTranslator("hc", (ExecutionFactory)new HardCodedExecutionFactory(){

            protected List<? extends List<?>> getData(QueryExpression command) {
                ArrayList result = new ArrayList();
                int size = command.getProjectedQuery().getDerivedColumns().size();
                for (int i = 0; i < 64; ++i) {
                    ArrayList<String> row = new ArrayList<String>(size);
                    for (int j = 0; j < size; ++j) {
                        row.add("abcdefghi" + j);
                    }
                    result.add(row);
                }
                return result;
            }
        });
        server.deployVDB("x", new ModelMetaData[]{mmd});
        jdbcTransport = new SocketListener(addr, config, server.getClientServiceRegistry(), (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (jdbcTransport != null) {
            jdbcTransport.stop();
        }
        server.stop();
    }

    @Test
    public void testLargeSelects() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:x@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
        long start = System.currentTimeMillis();
        for (int j = 0; j < 10; ++j) {
            Statement s = conn.createStatement(1003, 1007);
            Assert.assertTrue((boolean)s.execute("select * from x as x1, x as x2, x as x3"));
            ResultSet rs = s.getResultSet();
            int i = 0;
            while (rs.next()) {
                ++i;
            }
            s.close();
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    @Test
    public void testSmallSelects() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:x@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
        long start = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            Statement s = conn.createStatement(1003, 1007);
            Assert.assertTrue((boolean)s.execute("select 1"));
            ResultSet rs = s.getResultSet();
            int i = 0;
            while (rs.next()) {
                ++i;
            }
            s.close();
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    @Test
    public void testTextTable() throws Exception {
        Properties p = new Properties();
        p.setProperty("user", "testuser");
        p.setProperty("password", "testpassword");
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:x@mm://" + addr.getHostName() + ":" + jdbcTransport.getPort(), p);
        for (int j = 0; j < 10; ++j) {
            PreparedStatement ps = conn.prepareStatement("select * from (select * from texttable(cast (? as clob) columns x string width 100000 no row delimiter) as x limit 1) as x, texttable(cast (? as clob) columns x string width 100 no row delimiter) as y");
            ps.setClob(1, (Clob)TestTextTable.clobFromFile((String)"test.xml").getReference());
            ps.setClob(2, (Clob)TestTextTable.clobFromFile((String)"test.xml").getReference());
            ResultSet rs = ps.executeQuery();
            int i = 0;
            while (rs.next()) {
                ++i;
            }
            Assert.assertEquals((long)58454L, (long)i);
            ps.close();
        }
    }
}

