/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jboss.as.console.client.teiid.model.Session;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.ballroom.client.widgets.common.DefaultButton;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBSessionsTab
extends VDBProvider {
    private VDBPresenter presenter;
    private ListDataProvider<Session> sessionProvider = new ListDataProvider();
    private DefaultCellTable sessionTable;
    static DateTimeFormat dtf = DateTimeFormat.getFormat((String)"MM/dd/yy HH:mm:ss");

    public VDBSessionsTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        DefaultButton refreshBtn = new DefaultButton("Refresh", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                VDBSessionsTab.this.refresh();
            }
        });
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.sessionProvider.getList());
        this.sessionTable = this.getSessionTable((ColumnSortEvent.ListHandler<Session>)sortHandler);
        this.sessionProvider.addDataDisplay((HasData)this.sessionTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB selection) {
                if (selection != null && VDBSessionsTab.this.isActive(selection)) {
                    VDBSessionsTab.this.setVdbName(selection.getName());
                    VDBSessionsTab.this.setVdbVersion(selection.getVersion());
                    VDBSessionsTab.this.refresh();
                } else {
                    VDBSessionsTab.this.sessionProvider.getList().clear();
                }
            }
        });
        DefaultPager sessionTablePager = new DefaultPager();
        sessionTablePager.setDisplay((HasRows)this.sessionTable);
        Form form = new Form(Session.class);
        form.setNumColumns(1);
        form.setEnabled(false);
        TextItem clientHostNameLabel = new TextItem("clientHostName", "Client Host Name");
        TextItem clientHostAddressLabel = new TextItem("clientHardwareAddress", "Client Hardware Address");
        TextItem ipAddressLabel = new TextItem("iPAddress", "IP Address");
        TextItem securityDomainLabel = new TextItem("securityDomain", "Security Domain");
        form.setFields(new FormItem[]{clientHostNameLabel, clientHostAddressLabel, ipAddressLabel, securityDomainLabel});
        form.bind((CellTable)this.sessionTable);
        DefaultButton terminateAllBtn = new DefaultButton("Terminate All", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                VDBSessionsTab.this.terminateAll();
            }
        });
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add((Widget)refreshBtn);
        formPanel.add(this.sessionTable.asWidget());
        formPanel.add((Widget)sessionTablePager);
        formPanel.add((Widget)terminateAllBtn);
        formPanel.add((IsWidget)form);
        formPanel.setCellHorizontalAlignment((Widget)refreshBtn, HasHorizontalAlignment.ALIGN_RIGHT);
        formPanel.setCellHorizontalAlignment((Widget)terminateAllBtn, HasHorizontalAlignment.ALIGN_RIGHT);
        return formPanel;
    }

    private DefaultCellTable getSessionTable(ColumnSortEvent.ListHandler<Session> sortHandler) {
        ProvidesKey<Session> keyProvider = new ProvidesKey<Session>(){

            public Object getKey(Session item) {
                return item.getSessionId();
            }
        };
        DefaultCellTable table = new DefaultCellTable(20, (ProvidesKey)keyProvider);
        table.addColumnSortHandler(sortHandler);
        TextColumn<Session> idColumn = new TextColumn<Session>(){

            public String getValue(Session record) {
                return record.getSessionId();
            }
        };
        idColumn.setSortable(true);
        sortHandler.setComparator((Column)idColumn, (Comparator)new Comparator<Session>(){

            @Override
            public int compare(Session o1, Session o2) {
                return o1.getSessionId().compareTo(o2.getSessionId());
            }
        });
        TextColumn<Session> userNameColumn = new TextColumn<Session>(){

            public String getValue(Session record) {
                return String.valueOf(record.getUserName());
            }
        };
        userNameColumn.setSortable(true);
        sortHandler.setComparator((Column)userNameColumn, (Comparator)new Comparator<Session>(){

            @Override
            public int compare(Session o1, Session o2) {
                return o1.getUserName().compareTo(o2.getUserName());
            }
        });
        TextColumn<Session> createdColumn = new TextColumn<Session>(){

            public String getValue(Session record) {
                return dtf.format(new Date(record.getCreatedTime()), (TimeZone)com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0));
            }
        };
        createdColumn.setSortable(true);
        sortHandler.setComparator((Column)createdColumn, (Comparator)new Comparator<Session>(){

            @Override
            public int compare(Session o1, Session o2) {
                return o1.getCreatedTime().compareTo(o2.getCreatedTime());
            }
        });
        TextColumn<Session> lastPingColumn = new TextColumn<Session>(){

            public String getValue(Session record) {
                return dtf.format(new Date(Long.parseLong(record.getLastPingTime())), (TimeZone)com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0));
            }
        };
        lastPingColumn.setSortable(true);
        sortHandler.setComparator((Column)lastPingColumn, (Comparator)new Comparator<Session>(){

            @Override
            public int compare(Session o1, Session o2) {
                return o1.getLastPingTime().compareTo(o2.getLastPingTime());
            }
        });
        TextColumn<Session> applicationNameColumn = new TextColumn<Session>(){

            public String getValue(Session record) {
                return record.getApplicationName();
            }
        };
        applicationNameColumn.setSortable(true);
        sortHandler.setComparator((Column)applicationNameColumn, (Comparator)new Comparator<Session>(){

            @Override
            public int compare(Session o1, Session o2) {
                return o1.getApplicationName().compareTo(o2.getApplicationName());
            }
        });
        Column<Session, String> terminateBtn = new Column<Session, String>((Cell)new ButtonCell()){

            public String getValue(Session record) {
                return "Terminate";
            }
        };
        terminateBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<Session, String>(){

            public void update(int index, Session session, String value) {
                VDBSessionsTab.this.terminate(session);
            }
        });
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        table.setTitle("Sessions");
        table.addColumn((Column)idColumn, "Session Id");
        table.addColumn((Column)userNameColumn, "User");
        table.addColumn((Column)createdColumn, "Created");
        table.addColumn((Column)lastPingColumn, "Last Ping");
        table.addColumn((Column)applicationNameColumn, "Application");
        table.addColumn((Column)terminateBtn, "Terminate");
        table.getColumnSortList().push((Column)idColumn);
        return table;
    }

    public void setSessions(List<Session> sessions) {
        if (sessions != null && !sessions.isEmpty()) {
            this.sessionProvider.getList().clear();
            this.sessionProvider.getList().addAll(sessions);
            this.sessionTable.getSelectionModel().setSelected((Object)sessions.get(0), true);
        } else {
            this.sessionProvider.getList().clear();
        }
    }

    private void refresh() {
        this.presenter.getSessions(this.getVdbName(), this.getVdbVersion());
    }

    private void terminate(Session session) {
        this.presenter.terminateSession(session);
    }

    public void terminateSubmitted(Session session) {
        this.refresh();
    }

    private void terminateAll() {
        for (Session s : this.sessionProvider.getList()) {
            this.terminate(s);
        }
    }
}

