/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.layout.OneToOneLayout;
import org.jboss.as.console.client.teiid.SubsystemPresenter;
import org.jboss.as.console.client.teiid.TeiidModelForm;
import org.jboss.as.console.client.teiid.model.SubsystemConfiguration;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.NumberBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;

public class ConfigurationEditor {
    private SubsystemPresenter presenter;
    private TeiidModelForm<SubsystemConfiguration> commonForm;
    private TeiidModelForm<SubsystemConfiguration> threadsForm;
    private TeiidModelForm<SubsystemConfiguration> bufferManagerForm;
    private TeiidModelForm<SubsystemConfiguration> preparedPlanForm;
    private TeiidModelForm<SubsystemConfiguration> resultsetCacheForm;
    private TeiidModelForm<SubsystemConfiguration> distributedCacheForm;

    public ConfigurationEditor(SubsystemPresenter presenter) {
        this.presenter = presenter;
    }

    public void setConfigurationBean(SubsystemConfiguration bean) {
        this.commonForm.edit(bean);
        this.threadsForm.edit(bean);
        this.bufferManagerForm.edit(bean);
        this.preparedPlanForm.edit(bean);
        this.resultsetCacheForm.edit(bean);
        this.distributedCacheForm.edit(bean);
    }

    public Widget asWidget() {
        CheckBoxItem allowEnvFunction = new CheckBoxItem("allowEnvFunction", "Allow ENV Function");
        NumberBoxItem maxAsyncThreadCount = new NumberBoxItem("asyncThreadPoolCount", "Asynchronous Max Thread Count");
        NumberBoxItem maxRowsFetchSize = new NumberBoxItem("maxRowsFetchSize", "Max Rows Fetch Size");
        NumberBoxItem lobChunkSize = new NumberBoxItem("lobChunkSize", "Lob Chunk Size");
        NumberBoxItem queryThreshold = new NumberBoxItem("queryThreshold", "Query Threshhold");
        NumberBoxItem maxSourceRows = new NumberBoxItem("maxSourceRows", "Max Source Rows", true);
        CheckBoxItem throwExceptionOnMaxSourceRows = new CheckBoxItem("throwExceptionOnMaxSourceRows", "Throw Exception on Max Source Rows");
        CheckBoxItem detectChangeEvents = new CheckBoxItem("detectChangeEvents", "Detect Change Event");
        NumberBoxItem queryTimeout = new NumberBoxItem("queryTimeout", "Query Timeout");
        NumberBoxItem asyncThreadPool = new NumberBoxItem("asyncThreadPool", "Asynchronous Thread Pool");
        NumberBoxItem maxThreads = new NumberBoxItem("maxThreads", "Max Threads");
        NumberBoxItem maxActivePlans = new NumberBoxItem("maxActivePlans", "Max Active Plans");
        NumberBoxItem maxConcurrentThreads = new NumberBoxItem("maxConcurrentThreads", "Max # Source Concurrent Threads");
        NumberBoxItem timeSlice = new NumberBoxItem("timeSlice", "Time Slice");
        TextBoxItem workManager = new TextBoxItem("workManager", "Work Manager");
        CheckBoxItem useDisk = new CheckBoxItem("useDisk", "Use Disk");
        NumberBoxItem processorBatchSize = new NumberBoxItem("processorBatchSize", "Processor Batch Size");
        NumberBoxItem connectorBatchSize = new NumberBoxItem("connectorBatchSize", "Connector Batch Size");
        NumberBoxItem maxProcessingSize = new NumberBoxItem("maxProcessingSize", "Max Processing Size(KB)", true);
        NumberBoxItem maxReserveSize = new NumberBoxItem("maxReserveSize", "Max Reserved Memory(KB)", true);
        NumberBoxItem maxFileSize = new NumberBoxItem("maxFileSize", "Max Buffer File Size (MB)");
        NumberBoxItem maxBufferSize = new NumberBoxItem("maxBufferSize", "Max Storage Space(MB)");
        NumberBoxItem maxOpenFiles = new NumberBoxItem("maxOpenFiles", "Max Open Files");
        NumberBoxItem directMemorySize = new NumberBoxItem("directMemorySize", "Direct Memory Size(MB)", true);
        CheckBoxItem useOffHeapMemory = new CheckBoxItem("useOffHeapMemory", "Use Off Heap Memory");
        NumberBoxItem objectStorageSize = new NumberBoxItem("objectStorageSize", "Max Single Object Storage Size(bytes)");
        CheckBoxItem inlineLobs = new CheckBoxItem("inlineLobs", "Inline LOBs");
        CheckBoxItem ppcEnable = new CheckBoxItem("ppcEnable", "Enable");
        TextBoxItem ppcName = new TextBoxItem("ppcName", "Infinispan Cache Name");
        TextBoxItem ppcContainerName = new TextBoxItem("ppcContainerName", "Infinispan Cache Container Name");
        TextBoxItem dcJGroupsStack = new TextBoxItem("dcJGroupsStack", "JGroups Stack");
        TextBoxItem infinispanChannel = new TextBoxItem("infinispanChannel", "Infinispan Channel");
        TextBoxItem rscName = new TextBoxItem("rscName", "Infinispan Cache Name");
        CheckBoxItem rscEnable = new CheckBoxItem("rscEnable", "Enable");
        TextBoxItem rscContainerName = new TextBoxItem("rscContainerName", "Infinispan Cache Container Name");
        NumberBoxItem rscMaxStaleness = new NumberBoxItem("rscMaxStaleness", "Max Staleness", true);
        this.commonForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{allowEnvFunction, maxAsyncThreadCount, maxRowsFetchSize, lobChunkSize, queryThreshold, maxSourceRows, throwExceptionOnMaxSourceRows, detectChangeEvents, queryTimeout});
        this.threadsForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{asyncThreadPool, maxThreads, maxActivePlans, maxConcurrentThreads, timeSlice, workManager});
        this.bufferManagerForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{useDisk, processorBatchSize, connectorBatchSize, maxProcessingSize, maxReserveSize, maxFileSize, maxBufferSize, maxOpenFiles, directMemorySize, useOffHeapMemory, objectStorageSize, inlineLobs});
        this.distributedCacheForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{dcJGroupsStack, infinispanChannel});
        this.preparedPlanForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{ppcEnable, ppcName, ppcContainerName});
        this.resultsetCacheForm = new TeiidModelForm<SubsystemConfiguration>(SubsystemConfiguration.class, this.presenter, new FormItem[]{rscName, rscEnable, rscContainerName, rscMaxStaleness});
        HTML title = new HTML();
        title.setStyleName("content-header-label");
        title.setText("Query Engine");
        OneToOneLayout layoutBuilder = new OneToOneLayout().setPlain(true).setTitle("Query Engine").setHeadlineWidget((Widget)title).setDescription("Distributed query engine, that parses, plans and excutes user's SQL commands and provides results").addDetail("Common", this.commonForm.asWidget()).addDetail("Threads", this.threadsForm.asWidget()).addDetail("Buffer Manager", this.bufferManagerForm.asWidget()).addDetail("Prepared Plan Cache", this.preparedPlanForm.asWidget()).addDetail("Resultset Cache", this.resultsetCacheForm.asWidget()).addDetail("Distributed Cache", this.distributedCacheForm.asWidget());
        return layoutBuilder.build();
    }
}

