/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.jboss.as.console.client.shared.help.FormHelpPanel;
import org.jboss.as.console.client.shared.subsys.Baseadress;
import org.jboss.as.console.client.teiid.TranslatorEditor;
import org.jboss.as.console.client.teiid.model.Translator;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormAdapter;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.FormValidation;
import org.jboss.ballroom.client.widgets.forms.FormValidator;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.window.DialogueOptions;
import org.jboss.ballroom.client.widgets.window.WindowContentBuilder;
import org.jboss.dmr.client.ModelNode;

public class TranslatorWizard {
    private TranslatorEditor editor;

    public TranslatorWizard(TranslatorEditor translatorEditor) {
        this.editor = translatorEditor;
    }

    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("window-content");
        final Form form = new Form(Translator.class);
        TextBoxItem name = new TextBoxItem("name", "Name", true);
        TextBoxItem moduleName = new TextBoxItem("moduleName", "Module Name", true);
        form.setFields(new FormItem[]{name, moduleName});
        form.addFormValidator(new FormValidator(){

            public void validate(List<FormItem> items, FormValidation outcome) {
                TranslatorWizard.this.setError(this.findItem(items, "name"), "Name is required", outcome);
                TranslatorWizard.this.setError(this.findItem(items, "moduleName"), "Module Name is required", outcome);
            }

            private FormItem findItem(List<FormItem> items, String name) {
                for (FormItem item : items) {
                    if (!name.equals(item.getName())) continue;
                    return item;
                }
                return null;
            }
        });
        FormHelpPanel helpPanel = new FormHelpPanel(new FormHelpPanel.AddressCallback(){

            public ModelNode getAddress() {
                ModelNode address = Baseadress.get();
                address.add("subsystem", "teiid");
                address.add("translator", "*");
                return address;
            }
        }, (FormAdapter)form);
        layout.add(helpPanel.asWidget());
        layout.add(form.asWidget());
        DialogueOptions options = new DialogueOptions(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FormValidation validation = form.validate();
                if (!validation.hasErrors()) {
                    TranslatorWizard.this.finishStep((Translator)form.getUpdatedEntity());
                }
            }
        }, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TranslatorWizard.this.closeDialogue();
            }
        });
        return new WindowContentBuilder((Widget)layout, (Widget)options).build();
    }

    private void setError(FormItem item, String errorMsg, FormValidation outcome) {
        if (item.isRequired()) {
            boolean isNull;
            boolean errored = false;
            boolean bl = isNull = item.getValue() == null;
            if (!isNull) {
                if (item.getValue() instanceof String) {
                    String value = (String)item.getValue();
                    value = value.trim();
                    errored = value.isEmpty();
                }
            } else {
                errored = true;
            }
            if (errored) {
                outcome.addError(errorMsg);
                item.setErrMessage(errorMsg);
                item.setErroneous(true);
            }
        }
    }

    private void finishStep(Translator updated) {
        this.editor.createNewTranslator(updated);
    }

    private void closeDialogue() {
        this.editor.closeNewTranslatorWizard();
    }
}

