/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.NumberLabel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.jboss.as.console.client.teiid.model.CacheStatistics;
import org.jboss.as.console.client.teiid.model.MaterializedView;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.ballroom.client.widgets.common.DefaultButton;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBCachingTab
extends VDBProvider {
    private static final String INVALIDATE = "Invalidate";
    private VDBPresenter presenter;
    static DateTimeFormat dtf = DateTimeFormat.getFormat((String)"MM/dd/yy HH:mm:ss");
    private ListDataProvider<MaterializedView> matviewProvider = new ListDataProvider();
    private DefaultCellTable matviewTable;
    Label hitRatio = new Label();
    NumberLabel<Integer> totalEntries = new NumberLabel();
    NumberLabel<Integer> requestCount = new NumberLabel();

    public VDBCachingTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        Label hitRatioLabel = new Label("Hit Ratio:");
        hitRatioLabel.getElement().setAttribute("style", "margin-right:5px;");
        this.hitRatio.getElement().setAttribute("style", "margin-right:20px;");
        Label totalEntriesLabel = new Label("Total Entries:");
        totalEntriesLabel.getElement().setAttribute("style", "margin-right:5px;");
        this.totalEntries.getElement().setAttribute("style", "margin-right:20px;");
        Label requestCountLabel = new Label("Request Count:");
        requestCountLabel.getElement().setAttribute("style", "margin-right:5px;");
        this.requestCount.getElement().setAttribute("style", "margin-right:20px;");
        HorizontalPanel statsPanel = new HorizontalPanel();
        statsPanel.add((Widget)hitRatioLabel);
        statsPanel.add((Widget)this.hitRatio);
        statsPanel.add((Widget)totalEntriesLabel);
        statsPanel.add(this.totalEntries);
        statsPanel.add((Widget)requestCountLabel);
        statsPanel.add(this.requestCount);
        statsPanel.getElement().setAttribute("style", "margin-top:5px;margin-bottom:5px;");
        CaptionPanel cacheStatsPanel = new CaptionPanel("Cache Statistics");
        cacheStatsPanel.add((Widget)statsPanel);
        DefaultButton refreshBtn = new DefaultButton("Refresh", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                VDBCachingTab.this.refresh();
            }
        });
        Label matviewLabel = new Label("Materialized Tables");
        matviewLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:5px;font-weight:bold;");
        this.matviewTable = this.getMaterializedTable();
        this.matviewProvider.addDataDisplay((HasData)this.matviewTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB vdb) {
                if (vdb != null && VDBCachingTab.this.isActive(vdb)) {
                    VDBCachingTab.this.setVdbName(vdb.getName());
                    VDBCachingTab.this.setVdbVersion(vdb.getVersion());
                    VDBCachingTab.this.refresh();
                } else {
                    VDBCachingTab.this.setQueryResults(null, MaterializedView.class.getName());
                }
            }
        });
        DefaultPager propertiesTablePager = new DefaultPager();
        propertiesTablePager.setDisplay((HasRows)this.matviewTable);
        DefaultButton invalidateAllBtn = new DefaultButton("Invalidate All", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                VDBCachingTab.this.invalidateAll();
            }
        });
        invalidateAllBtn.getElement().setAttribute("style", "margin-top:5px;margin-bottom:5px;");
        CaptionPanel clearCacheCaptionPanel = new CaptionPanel("Clear Cache");
        VerticalPanel clearCachePanel = new VerticalPanel();
        final RadioButton resultSetBtn = new RadioButton("clearcache", "ResultSet");
        RadioButton preparedPlanBtn = new RadioButton("clearcache", "Prepared Plan");
        DefaultButton clearBtn = new DefaultButton("Clear", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                if (resultSetBtn.getValue().booleanValue()) {
                    VDBCachingTab.this.clearCache("QUERY_SERVICE_RESULT_SET_CACHE");
                } else {
                    VDBCachingTab.this.clearCache("PREPARED_PLAN_CACHE");
                }
            }
        });
        resultSetBtn.setEnabled(true);
        resultSetBtn.setValue(Boolean.valueOf(true));
        preparedPlanBtn.setEnabled(true);
        clearCachePanel.add((Widget)resultSetBtn);
        clearCachePanel.add((Widget)preparedPlanBtn);
        clearCachePanel.setCellHorizontalAlignment((Widget)resultSetBtn, HasHorizontalAlignment.ALIGN_LEFT);
        clearCachePanel.setCellHorizontalAlignment((Widget)preparedPlanBtn, HasHorizontalAlignment.ALIGN_LEFT);
        clearCachePanel.add((Widget)clearBtn);
        clearCacheCaptionPanel.add((Widget)clearCachePanel);
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add((Widget)cacheStatsPanel);
        formPanel.add(matviewLabel.asWidget());
        formPanel.add((Widget)refreshBtn);
        formPanel.add(this.matviewTable.asWidget());
        formPanel.add((Widget)propertiesTablePager);
        formPanel.add((Widget)invalidateAllBtn);
        formPanel.add((Widget)clearCacheCaptionPanel);
        formPanel.setCellHorizontalAlignment((Widget)refreshBtn, HasHorizontalAlignment.ALIGN_RIGHT);
        formPanel.setCellHorizontalAlignment((Widget)invalidateAllBtn, HasHorizontalAlignment.ALIGN_RIGHT);
        return formPanel;
    }

    private DefaultCellTable getMaterializedTable() {
        ProvidesKey<MaterializedView> keyProvider = new ProvidesKey<MaterializedView>(){

            public Object getKey(MaterializedView item) {
                return VDBCachingTab.this.getVdbName() + "." + VDBCachingTab.this.getVdbVersion() + "." + item.getModelName() + "." + item.getTableName();
            }
        };
        DefaultCellTable table = new DefaultCellTable(10, (ProvidesKey)keyProvider);
        TextColumn<MaterializedView> nameColumn = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return record.getTableName();
            }
        };
        nameColumn.setSortable(true);
        TextColumn<MaterializedView> modelNameColumn = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return String.valueOf(record.getModelName());
            }
        };
        modelNameColumn.setSortable(true);
        TextColumn<MaterializedView> validColumn = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return String.valueOf(record.isValid());
            }
        };
        validColumn.setSortable(true);
        TextColumn<MaterializedView> lastUpdatedTime = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return record.getLastUpdatedTime();
            }
        };
        lastUpdatedTime.setSortable(true);
        TextColumn<MaterializedView> loadStateColumn = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return record.getLoadState();
            }
        };
        loadStateColumn.setSortable(true);
        TextColumn<MaterializedView> cardinalityColumn = new TextColumn<MaterializedView>(){

            public String getValue(MaterializedView record) {
                return String.valueOf(record.getCardinality());
            }
        };
        loadStateColumn.setSortable(true);
        Column<MaterializedView, String> invalidateBtn = new Column<MaterializedView, String>((Cell)new ButtonCell()){

            public String getValue(MaterializedView record) {
                return "Reload";
            }
        };
        invalidateBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<MaterializedView, String>(){

            public void update(int index, MaterializedView table, String value) {
                VDBCachingTab.this.invalidate(table, "Reload");
            }
        });
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        table.setTitle("Mateiralized Tables");
        table.addColumn((Column)nameColumn, "View");
        table.addColumn((Column)modelNameColumn, "Model Name");
        table.addColumn((Column)validColumn, "Valid");
        table.addColumn((Column)lastUpdatedTime, "Last Updated");
        table.addColumn((Column)loadStateColumn, "State");
        table.addColumn((Column)cardinalityColumn, "# Rows");
        table.addColumn((Column)invalidateBtn, INVALIDATE);
        return table;
    }

    private void invalidate(MaterializedView view, String queryId) {
        String sql = "CALL SYSADMIN.loadMatView('" + view.getModelName() + "', '" + view.getTableName() + "', true)";
        this.presenter.executeQuery(this.getVdbName(), this.getVdbVersion(), sql, queryId);
    }

    public <T> void setQueryResults(List<T> results, String clazz) {
        if (clazz.equals(MaterializedView.class.getName())) {
            if (results != null) {
                this.matviewProvider.getList().clear();
                this.matviewProvider.getList().addAll(results);
                if (!results.isEmpty()) {
                    this.matviewTable.getSelectionModel().setSelected(results.get(0), true);
                }
            } else {
                this.matviewProvider.getList().clear();
            }
        } else if (clazz.equals(INVALIDATE)) {
            this.refresh();
        }
    }

    private void refresh() {
        String sql = "SELECT M.VDBName, M.SchemaName, M.Name, S.TargetSchemaName, S.TargetName, S.Valid, S.LoadState, S.Updated, S.Cardinality FROM SYSADMIN.MatViews AS M, TABLE(CALL SYSADMIN.matViewStatus(M.SchemaName, M.Name)) AS S";
        this.presenter.executeQuery(this.getVdbName(), this.getVdbVersion(), sql, MaterializedView.class.getName());
        this.presenter.getCacheStatistics();
    }

    private void invalidateAll() {
        List views = this.matviewProvider.getList();
        int i = 0;
        for (i = 0; i < views.size() - 1; ++i) {
            this.invalidate((MaterializedView)views.get(i), "NoRefresh");
        }
        this.invalidate((MaterializedView)views.get(i), INVALIDATE);
    }

    private void clearCache(String cacheType) {
        this.presenter.clearCache(this.getVdbName(), this.getVdbVersion(), cacheType);
    }

    public void setCacheStatistics(CacheStatistics cache) {
        if (cache != null) {
            this.hitRatio.setText(cache.getHitRatio());
            this.totalEntries.setValue((Object)cache.getTotalEntries());
            this.requestCount.setValue((Object)cache.getRequestCount());
        } else {
            this.hitRatio.setText("0.0");
            this.totalEntries.setValue((Object)0);
            this.requestCount.setValue((Object)0);
        }
    }
}

