/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.console.client.teiid.model.DataModelFactory;
import org.jboss.as.console.client.teiid.model.KeyValuePair;
import org.jboss.as.console.client.teiid.model.Model;
import org.jboss.as.console.client.teiid.model.SourceMapping;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.ValidityError;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.as.console.client.teiid.widgets.DefaultPopUpWindow;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBModelsTab
extends VDBProvider {
    private DataModelFactory factory;
    private VDBPresenter presenter;

    public VDBModelsTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        final ListDataProvider modelProvider = new ListDataProvider();
        final ListDataProvider propertyProvider = new ListDataProvider();
        final ListDataProvider errorProvider = new ListDataProvider();
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(modelProvider.getList());
        final DefaultCellTable modelsTable = this.getModelTable((ColumnSortEvent.ListHandler<Model>)sortHandler);
        modelProvider.addDataDisplay((HasData)modelsTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB selection) {
                if (selection != null && !selection.getModels().isEmpty()) {
                    if (VDBModelsTab.this.isActive(selection)) {
                        Column<Model, String> schemaBtn = new Column<Model, String>((Cell)new ButtonCell()){

                            public String getValue(Model record) {
                                return "DDL";
                            }
                        };
                        schemaBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<Model, String>(){

                            public void update(int index, Model model, String value) {
                                VDBModelsTab.this.showSchema(model);
                            }
                        });
                        modelsTable.addColumn((Column)schemaBtn, "Schema");
                        modelProvider.refresh();
                    } else {
                        modelsTable.removeColumn(8);
                        modelProvider.refresh();
                    }
                    VDBModelsTab.this.setVdbName(selection.getName());
                    VDBModelsTab.this.setVdbVersion(selection.getVersion());
                    modelProvider.getList().clear();
                    propertyProvider.getList().clear();
                    errorProvider.getList().clear();
                    List models = VDBModelsTab.this.addMultiSourceModels(selection.getModels());
                    modelProvider.getList().addAll(models);
                    modelsTable.getSelectionModel().setSelected(models.get(0), true);
                } else {
                    VDBModelsTab.this.setVdbName(null);
                    VDBModelsTab.this.setVdbVersion("0");
                    modelProvider.getList().clear();
                    propertyProvider.getList().clear();
                    errorProvider.getList().clear();
                }
            }
        });
        DefaultPager modelsTablePager = new DefaultPager();
        modelsTablePager.setDisplay((HasRows)modelsTable);
        Form form = new Form(Model.class);
        form.setNumColumns(1);
        form.setEnabled(false);
        TextItem pathLabel = new TextItem("modelPath", "Path");
        TextItem descriptionLabel = new TextItem("description", "Description");
        form.setFields(new FormItem[]{pathLabel, descriptionLabel});
        form.bind((CellTable)modelsTable);
        Label propertiesLabel = new Label("Properties");
        propertiesLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable<KeyValuePair> propertiesTable = VDBView.buildPropertiesTable();
        propertyProvider.addDataDisplay(propertiesTable);
        VDBView.onTableSectionChange(modelsTable, new VDBView.TableSelectionCallback<Model>(){

            @Override
            public void onSelectionChange(Model model) {
                VDBModelsTab.this.setModelName(model.getName());
                if (!model.getProperties().isEmpty()) {
                    propertyProvider.getList().clear();
                    propertyProvider.getList().addAll(model.getProperties());
                } else {
                    propertyProvider.getList().clear();
                }
            }
        });
        DefaultPager propertiesTablePager = new DefaultPager();
        propertiesTablePager.setDisplay(propertiesTable);
        Label errorLabel = new Label("Errors");
        errorLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable<ValidityError> errorsTable = VDBView.buildErrorTable();
        errorProvider.addDataDisplay(errorsTable);
        VDBView.onTableSectionChange(modelsTable, new VDBView.TableSelectionCallback<Model>(){

            @Override
            public void onSelectionChange(Model model) {
                errorProvider.getList().clear();
                errorProvider.getList().addAll(model.getValidityErrors());
            }
        });
        DefaultPager errorsTablePager = new DefaultPager();
        errorsTablePager.setDisplay(errorsTable);
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add(modelsTable.asWidget());
        formPanel.add((Widget)modelsTablePager);
        formPanel.add(form.asWidget());
        formPanel.add(propertiesLabel.asWidget());
        formPanel.add(propertiesTable.asWidget());
        formPanel.add((Widget)propertiesTablePager);
        formPanel.add(errorLabel.asWidget());
        formPanel.add(errorsTable.asWidget());
        formPanel.add((Widget)errorsTablePager);
        return formPanel;
    }

    private DefaultCellTable getModelTable(ColumnSortEvent.ListHandler<Model> sortHandler) {
        ProvidesKey<Model> keyProvider = new ProvidesKey<Model>(){

            public Object getKey(Model item) {
                String key = "";
                if (!item.getSourceMappings().isEmpty()) {
                    SourceMapping sm = item.getSourceMappings().get(0);
                    key = sm.getSourceName();
                }
                return VDBModelsTab.this.getVdbName() + "." + VDBModelsTab.this.getVdbVersion() + "." + item.getName() + "." + key;
            }
        };
        DefaultCellTable modelsTable = new DefaultCellTable(5, (ProvidesKey)keyProvider);
        modelsTable.addColumnSortHandler(sortHandler);
        TextColumn<Model> nameColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                return record.getName();
            }
        };
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TextColumn<Model> modelTypeColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                return record.getModelType();
            }
        };
        modelTypeColumn.setSortable(true);
        sortHandler.setComparator((Column)modelTypeColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                return o1.getModelType().compareTo(o2.getModelType());
            }
        });
        TextColumn<Model> visibleColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                return String.valueOf(record.isVisible());
            }
        };
        visibleColumn.setSortable(true);
        sortHandler.setComparator((Column)visibleColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                return o1.isVisible().compareTo(o2.isVisible());
            }
        });
        TextColumn<Model> multiSourceColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                return String.valueOf(VDBModelsTab.this.isMultiSource(record));
            }
        };
        TextColumn<Model> sourceNameColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                if (VDBModelsTab.this.isSource(record)) {
                    return record.getSourceMappings().get(0).getSourceName();
                }
                return "";
            }
        };
        sourceNameColumn.setSortable(true);
        sortHandler.setComparator((Column)sourceNameColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                SourceMapping sm1 = o1.getSourceMappings().get(0);
                SourceMapping sm2 = o2.getSourceMappings().get(0);
                return sm1.getSourceName().compareTo(sm2.getSourceName());
            }
        });
        Column<Model, String> jndiNameColumn = new Column<Model, String>((Cell)new EditTextCell()){

            public String getValue(Model record) {
                if (VDBModelsTab.this.isSource(record)) {
                    return record.getSourceMappings().get(0).getJndiName();
                }
                return "";
            }
        };
        jndiNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Model, String>(){

            public void update(int index, Model model, String value) {
                VDBModelsTab.this.changeDataSourceName(model, value);
            }
        });
        jndiNameColumn.setSortable(true);
        sortHandler.setComparator((Column)jndiNameColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                SourceMapping sm1 = o1.getSourceMappings().get(0);
                SourceMapping sm2 = o2.getSourceMappings().get(0);
                return sm1.getJndiName().compareTo(sm2.getJndiName());
            }
        });
        TextColumn<Model> translatorNameColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                if (VDBModelsTab.this.isSource(record)) {
                    return record.getSourceMappings().get(0).getTranslatorName();
                }
                return "";
            }
        };
        translatorNameColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Model, String>(){

            public void update(int index, Model model, String value) {
                VDBModelsTab.this.changeTranslatorName(model, value);
            }
        });
        translatorNameColumn.setSortable(true);
        sortHandler.setComparator((Column)translatorNameColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                SourceMapping sm1 = o1.getSourceMappings().get(0);
                SourceMapping sm2 = o2.getSourceMappings().get(0);
                return sm1.getTranslatorName().compareTo(sm2.getTranslatorName());
            }
        });
        TextColumn<Model> schemaStatusColumn = new TextColumn<Model>(){

            public String getValue(Model record) {
                return record.getMetadataStatus();
            }
        };
        schemaStatusColumn.setSortable(true);
        sortHandler.setComparator((Column)schemaStatusColumn, (Comparator)new Comparator<Model>(){

            @Override
            public int compare(Model o1, Model o2) {
                return o1.getMetadataStatus().compareTo(o2.getMetadataStatus());
            }
        });
        modelsTable.setTitle("Models");
        modelsTable.addColumn((Column)nameColumn, "Name");
        modelsTable.addColumn((Column)modelTypeColumn, "Type");
        modelsTable.addColumn((Column)visibleColumn, "Visible?");
        modelsTable.addColumn((Column)multiSourceColumn, "Multi-Source?");
        modelsTable.addColumn((Column)sourceNameColumn, "Source Name");
        modelsTable.addColumn((Column)translatorNameColumn, "Translator Name");
        modelsTable.addColumn((Column)jndiNameColumn, "Datasource JNDI Name");
        modelsTable.addColumn((Column)schemaStatusColumn, "Schema Status");
        modelsTable.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        modelsTable.getColumnSortList().push((Column)nameColumn);
        return modelsTable;
    }

    private boolean isSource(Model model) {
        return model.getModelType() == null || model.getModelType().equals("PHYSICAL");
    }

    private boolean isMultiSource(Model record) {
        for (KeyValuePair kv : record.getProperties()) {
            if (!kv.getKey().equals("supports-multi-source-bindings")) continue;
            return Boolean.TRUE.equals(Boolean.parseBoolean(kv.getValue()));
        }
        return Boolean.FALSE;
    }

    private List<Model> addMultiSourceModels(List<Model> models) {
        ArrayList<Model> normalizedList = new ArrayList<Model>();
        for (Model m : models) {
            if (m.getSourceMappings().size() > 1) {
                for (SourceMapping sm : m.getSourceMappings()) {
                    ArrayList<SourceMapping> mappings = new ArrayList<SourceMapping>();
                    Model copy = (Model)this.factory.getModel().as();
                    copy.setName(m.getName());
                    copy.setModelType(m.getModelType());
                    copy.setDescription(m.getDescription());
                    copy.setMetadataType(m.getMetadataType());
                    copy.setModelPath(m.getModelType());
                    copy.setProperties(m.getProperties());
                    copy.setVisible(m.isVisible());
                    copy.setValidityErrors(m.getValidityErrors());
                    mappings.add(sm);
                    copy.setSourceMappings(mappings);
                    normalizedList.add(copy);
                }
                continue;
            }
            normalizedList.add(m);
        }
        return normalizedList;
    }

    public void setDataModelFactory(DataModelFactory factory) {
        this.factory = factory;
    }

    private void showSchema(Model model) {
        this.presenter.getSchema(this.getVdbName(), this.getVdbVersion(), model.getName());
    }

    public void setSchema(String ddl) {
        DefaultPopUpWindow schemaDialogBox = new DefaultPopUpWindow("Schema", ddl);
        schemaDialogBox.show();
    }

    public void changeDataSourceName(Model model, String dataSourceName) {
        SourceMapping sm = model.getSourceMappings().get(0);
        if (!sm.getJndiName().equals(dataSourceName)) {
            this.presenter.assignDataSource(this.getVdbName(), this.getVdbVersion(), model.getName(), sm.getSourceName(), sm.getTranslatorName(), dataSourceName);
        }
    }

    public void changeTranslatorName(Model model, String translatorName) {
        SourceMapping sm = model.getSourceMappings().get(0);
        if (!sm.getTranslatorName().equals(translatorName)) {
            this.presenter.assignDataSource(this.getVdbName(), this.getVdbVersion(), model.getName(), sm.getSourceName(), translatorName, sm.getJndiName());
        }
    }
}

