/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.Proxy;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.BeanFactory;
import org.jboss.as.console.client.shared.runtime.RuntimeBaseAddress;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.teiid.model.CacheStatistics;
import org.jboss.as.console.client.teiid.model.DataModelFactory;
import org.jboss.as.console.client.teiid.model.EngineStatistics;
import org.jboss.as.console.client.teiid.model.MaterializedView;
import org.jboss.as.console.client.teiid.model.Model;
import org.jboss.as.console.client.teiid.model.Request;
import org.jboss.as.console.client.teiid.model.Session;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.ValidityError;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.spi.RequiredResources;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;

public class VDBPresenter
extends Presenter<MyView, MyProxy> {
    private DispatchAsync dispatcher;
    private RevealStrategy revealStrategy;
    private DataModelFactory factory;
    private EntityAdapter<VDB> vdbAdaptor;
    private EntityAdapter<Request> requestAdaptor;
    private EntityAdapter<Session> sessionAdaptor;
    private EntityAdapter<MaterializedView> matViewAdaptor;
    private EntityAdapter<CacheStatistics> cacheAdaptor;
    private EntityAdapter<EngineStatistics> runtimeAdaptor;

    @Inject
    public VDBPresenter(EventBus eventBus, MyView view, MyProxy proxy, DispatchAsync dispatcher, ApplicationMetaData metaData, RevealStrategy revealStrategy, BeanFactory factory) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.dispatcher = dispatcher;
        this.revealStrategy = revealStrategy;
        this.factory = (DataModelFactory)factory;
        this.vdbAdaptor = new EntityAdapter(VDB.class, metaData);
        this.requestAdaptor = new EntityAdapter(Request.class, metaData);
        this.sessionAdaptor = new EntityAdapter(Session.class, metaData);
        this.matViewAdaptor = new EntityAdapter(MaterializedView.class, metaData);
        this.cacheAdaptor = new EntityAdapter(CacheStatistics.class, metaData);
        this.runtimeAdaptor = new EntityAdapter(EngineStatistics.class, metaData);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
        ((MyView)this.getView()).setDataModelFactory(this.factory);
    }

    protected void onReset() {
        super.onReset();
        this.getEngineStatistics();
        if (this.isVisible()) {
            this.refresh(true);
        }
    }

    protected void onReveal() {
        super.onReveal();
    }

    protected void revealInParent() {
        this.revealStrategy.revealInRuntimeParent((Presenter)this);
    }

    public void refresh(boolean paging) {
        this.getVDBs();
    }

    public void getVDBs() {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-vdbs");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List vdbs = VDBPresenter.this.vdbAdaptor.fromDMRList(response.get("result").asList());
                    for (VDB vdb : vdbs) {
                        boolean valid = true;
                        for (Model m : vdb.getModels()) {
                            if (m.getValidityErrors().isEmpty()) continue;
                            for (ValidityError ve : m.getValidityErrors()) {
                                if (!ve.getSeverity().equals("ERROR")) continue;
                                valid = false;
                            }
                        }
                        vdb.setValid(valid);
                    }
                    ((MyView)VDBPresenter.this.getView()).setDeployedVDBs(vdbs);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to get list of current VDBs deployed in the system", (String)caught.getMessage());
            }
        });
    }

    public void removeRoleName(final String vdbName, final String version, String dataRole, final String mappedRole) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove-data-role");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("data-role").set(new ModelNode().set(dataRole));
        operation.get("mapped-role").set(new ModelNode().set(mappedRole));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)(mappedRole + " role removed from VDB " + vdbName + "." + version));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to remove '" + mappedRole + "' role from the VDB = " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void addRoleName(final String vdbName, final String version, String dataRole, final String mappedRole) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add-data-role");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("data-role").set(new ModelNode().set(dataRole));
        operation.get("mapped-role").set(new ModelNode().set(mappedRole));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)(mappedRole + " role added to VDB " + vdbName + "." + version));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to add role", (String)caught.getMessage());
            }
        });
    }

    public void getRequests(final String vdbName, final String version, boolean includeSourceQueries) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-requests-per-vdb");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("include-source").set(new ModelNode().set(includeSourceQueries));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List requests = VDBPresenter.this.requestAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(requests);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to get in process requests for VDB " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void getQueryPlan(Request request) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("get-query-plan");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(request.getSessionId()));
        operation.get("execution-id").set(new ModelNode().set(request.getExecutionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                String plan = null;
                if (response.get("result").isDefined()) {
                    plan = response.get("result").asString();
                }
                if (plan != null && !plan.trim().isEmpty()) {
                    ((MyView)VDBPresenter.this.getView()).setQueryPlan(plan);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setQueryPlan("<node name=\"query\"><property name=\"noplan\">No Plan found, query might have finished executing!</property></node>");
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to get query plan", (String)caught.getMessage());
            }
        });
    }

    public void cancelRequest(final Request request) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("cancel-request");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(request.getSessionId()));
        operation.get("execution-id").set(new ModelNode().set(request.getExecutionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).cancelSubmitted(request);
                    Console.info((String)("Query Cancel Submitted. Session Id:" + request.getSessionId() + ", Execution Id:" + request.getExecutionId()));
                } else {
                    ((MyView)VDBPresenter.this.getView()).cancelSubmitted(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Filed to submit Query Cancel. Session Id:" + request.getSessionId() + ", Execution Id:" + request.getExecutionId()), (String)caught.getMessage());
            }
        });
    }

    public void getSchema(final String vdbName, final String version, final String modelName) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("get-schema");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("model-name").set(new ModelNode().set(modelName));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).setModelSchema(response.get("result").asString());
                } else {
                    ((MyView)VDBPresenter.this.getView()).setModelSchema(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to get schema of the model = " + modelName + " in vdb = " + vdbName + " with version = " + version), (String)caught.getMessage());
            }
        });
    }

    public void getSessions(final String vdbName, final String version) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-sessions");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List sessions = VDBPresenter.this.sessionAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setVDBSessions(vdbName, version, sessions);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setVDBRequests(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to get current sessions for vdb = " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void terminateSession(final Session session) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("terminate-session");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(session.getSessionId()));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    ((MyView)VDBPresenter.this.getView()).terminateSessionSubmitted(session);
                    Console.info((String)("Terminate Session Submitted. Session Id:" + session.getSessionId()));
                } else {
                    ((MyView)VDBPresenter.this.getView()).terminateSessionSubmitted(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to terminate seession '" + session), (String)caught.getMessage());
            }
        });
    }

    public <T> void executeQuery(String vdbName, String version, final String sql, final String clazz) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("execute-query");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("sql-query").set(new ModelNode().set(sql));
        operation.get("timeout-in-milli").set(new ModelNode().set(-1));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    if (VDBPresenter.this.getEntityAdapter(clazz) != null) {
                        ((MyView)VDBPresenter.this.getView()).setQueryResults(VDBPresenter.this.matViewAdaptor.fromDMRList(response.get("result").asList()), sql, clazz);
                    } else {
                        ((MyView)VDBPresenter.this.getView()).setQueryResults(response.get("result").asList(), sql, clazz);
                    }
                } else {
                    ((MyView)VDBPresenter.this.getView()).setQueryResults(response.get("result").asList(), sql, clazz);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to execute query, or timeout occured", (String)caught.getMessage());
            }
        });
    }

    private <T> EntityAdapter<T> getEntityAdapter(String clazz) {
        if (clazz.equals(MaterializedView.class.getName())) {
            return this.matViewAdaptor;
        }
        return null;
    }

    public void clearCache(final String vdbName, final String version, final String cacheType) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("clear-cache");
        operation.get("address").set(address);
        operation.get("cache-type").set(new ModelNode().set(cacheType));
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("Cache " + cacheType + " on VDB = " + vdbName + "." + version + " has been cleared"));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to clear Cache " + cacheType + " on VDB = " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void changeConnectionType(final String vdbName, final String version, final String connType) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("change-vdb-connection-type");
        operation.get("address").set(address);
        operation.get("connection-type").set(new ModelNode().set(connType));
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ((MyView)VDBPresenter.this.getView()).connectionTypeChanged(vdbName, version);
                Console.info((String)("Changing Connection type to " + connType + " on VDB = " + vdbName + "." + version + " has been cleared"));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to change Connection type to " + connType + " on VDB = " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void assignDataSource(final String vdbName, final String version, final String modelName, String sourceName, String translatorName, final String dataSourceName) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("assign-datasource");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        operation.get("model-name").set(new ModelNode().set(modelName));
        operation.get("source-name").set(new ModelNode().set(sourceName));
        operation.get("translator-name").set(new ModelNode().set(translatorName));
        operation.get("ds-name").set(new ModelNode().set(dataSourceName));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("Changing the JNDI name of the data source on VDB =" + vdbName + "." + version + " on Model=" + modelName + " to " + dataSourceName));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Changing the JNDI name of the data source on VDB =" + vdbName + "." + version + " on Model=" + modelName + " to " + dataSourceName), (String)caught.getMessage());
            }
        });
    }

    public void reloadVDB(final String vdbName, final String version) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("restart-vdb");
        operation.get("address").set(address);
        operation.get("vdb-name").set(new ModelNode().set(vdbName));
        operation.get("vdb-version").set(new ModelNode().set(version));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                Console.info((String)("VDB " + vdbName + "." + version + " has been submitted for reload"));
                ((MyView)VDBPresenter.this.getView()).vdbReloaded(vdbName, version);
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to reload the VDB = " + vdbName + "." + version), (String)caught.getMessage());
            }
        });
    }

    public void getCacheStatistics() {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("cache-statistics");
        operation.get("address").set(address);
        operation.get("cache-type").set(new ModelNode().set("QUERY_SERVICE_RESULT_SET_CACHE"));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    CacheStatistics cache = (CacheStatistics)VDBPresenter.this.cacheAdaptor.fromDMR(response.get("result"));
                    ((MyView)VDBPresenter.this.getView()).setCacheStatistics(cache);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setCacheStatistics(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to get cache statistics", (String)caught.getMessage());
            }
        });
    }

    public void getSourceRequests(final Request selection) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("list-requests-per-session");
        operation.get("address").set(address);
        operation.get("session").set(new ModelNode().set(selection.getSessionId()));
        operation.get("include-source").set(new ModelNode().set(true));
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    List requests = VDBPresenter.this.requestAdaptor.fromDMRList(response.get("result").asList());
                    ((MyView)VDBPresenter.this.getView()).setSourceRequests(selection, requests);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setSourceRequests(selection, null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to get data source requests for session = " + selection.getSessionId()), (String)caught.getMessage());
            }
        });
    }

    public void getEngineStatistics() {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("engine-statistics");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    EngineStatistics stats = (EngineStatistics)VDBPresenter.this.runtimeAdaptor.fromDMR(response.get("result"));
                    ((MyView)VDBPresenter.this.getView()).setEngineStatistics(stats);
                } else {
                    ((MyView)VDBPresenter.this.getView()).setEngineStatistics(null);
                }
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to retrieve query engine statistics for Teiid", (String)caught.getMessage());
            }
        });
    }

    public static interface MyView
    extends View {
        public void setDeployedVDBs(List<VDB> var1);

        public void setPresenter(VDBPresenter var1);

        public void setVDBRequests(List<Request> var1);

        public void setQueryPlan(String var1);

        public void cancelSubmitted(Request var1);

        public void setDataModelFactory(DataModelFactory var1);

        public void setModelSchema(String var1);

        public void terminateSessionSubmitted(Session var1);

        public void setVDBSessions(String var1, String var2, List<Session> var3);

        public <T> void setQueryResults(List<T> var1, String var2, String var3);

        public void connectionTypeChanged(String var1, String var2);

        public void vdbReloaded(String var1, String var2);

        public void setCacheStatistics(CacheStatistics var1);

        public void setSourceRequests(Request var1, List<Request> var2);

        public void setEngineStatistics(EngineStatistics var1);
    }

    @RuntimeExtension(name="Teiid", key="teiid")
    @RequiredResources(resources={"{selected.profile}/subsystem=teiid"})
    @ProxyCodeSplit
    @NameToken(value={"vdb-runtime"})
    public static interface MyProxy
    extends Proxy<VDBPresenter>,
    Place {
    }
}

