/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.core.SuspendableViewImpl;
import org.jboss.as.console.client.layout.MultipleToOneLayout;
import org.jboss.as.console.client.teiid.model.CacheStatistics;
import org.jboss.as.console.client.teiid.model.DataModelFactory;
import org.jboss.as.console.client.teiid.model.EngineStatistics;
import org.jboss.as.console.client.teiid.model.KeyValuePair;
import org.jboss.as.console.client.teiid.model.Request;
import org.jboss.as.console.client.teiid.model.Session;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.ValidityError;
import org.jboss.as.console.client.teiid.runtime.SQLWorkbenchEditor;
import org.jboss.as.console.client.teiid.runtime.TeiidMetricsEditor;
import org.jboss.as.console.client.teiid.runtime.VDBCachingTab;
import org.jboss.as.console.client.teiid.runtime.VDBDataRolesTab;
import org.jboss.as.console.client.teiid.runtime.VDBModelsTab;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBRequestsTab;
import org.jboss.as.console.client.teiid.runtime.VDBSessionsTab;
import org.jboss.as.console.client.teiid.runtime.VDBSummaryTab;
import org.jboss.as.console.client.teiid.runtime.VDBTranslatorsTab;
import org.jboss.as.console.client.teiid.widgets.TeiidIcons;
import org.jboss.as.console.client.teiid.widgets.TextAreaCell;
import org.jboss.as.console.client.widgets.pages.PagedView;
import org.jboss.as.console.client.widgets.tabs.DefaultTabLayoutPanel;
import org.jboss.ballroom.client.widgets.icons.Icons;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.dmr.client.ModelNode;
import org.jboss.gwt.circuit.Dispatcher;

public class VDBView
extends SuspendableViewImpl
implements VDBPresenter.MyView {
    private ListDataProvider<VDB> vdbProvider = new ListDataProvider();
    private DefaultCellTable vdbTable;
    private VDBPresenter presenter;
    private VDBRequestsTab vdbRequestsTab;
    private VDBModelsTab vdbModelsTab;
    private VDBSessionsTab vdbSessionsTab;
    private VDBCachingTab vdbCachingTab;
    private DataModelFactory factory;
    private TeiidMetricsEditor metricsEditor;
    private SQLWorkbenchEditor sqlWorkbenchEditor;
    private Dispatcher circuit;

    @Inject
    public VDBView(Dispatcher circuit) {
        this.circuit = circuit;
    }

    @Override
    public void setDataModelFactory(DataModelFactory factory) {
        this.factory = factory;
    }

    @Override
    public void setDeployedVDBs(List<VDB> vdbs) {
        if (vdbs != null && !vdbs.isEmpty()) {
            this.vdbProvider.getList().clear();
            this.vdbProvider.getList().addAll(vdbs);
            this.vdbTable.getSelectionModel().setSelected((Object)vdbs.get(0), true);
            this.sqlWorkbenchEditor.setVDBList(vdbs);
        } else {
            this.vdbProvider.getList().clear();
            this.sqlWorkbenchEditor.setVDBList(vdbs);
        }
    }

    @Override
    public void setPresenter(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setVDBRequests(List<Request> requests) {
        this.vdbRequestsTab.setRequests(requests);
    }

    @Override
    public void setQueryPlan(String plan) {
        this.vdbRequestsTab.setQueryPlan(plan);
    }

    @Override
    public void cancelSubmitted(Request request) {
        this.vdbRequestsTab.cancelSubmitted(request);
    }

    @Override
    public void setModelSchema(String ddl) {
        this.vdbModelsTab.setSchema(ddl);
    }

    public Widget createWidget() {
        DefaultTabLayoutPanel layout = new DefaultTabLayoutPanel(40.0, Style.Unit.PX);
        layout.addStyleName("default-tabpanel");
        PagedView pages = new PagedView(true);
        this.metricsEditor = new TeiidMetricsEditor();
        this.sqlWorkbenchEditor = new SQLWorkbenchEditor();
        pages.addPage("Virtual Databases", this.mainPageAsWidget());
        pages.addPage("Metrics", this.metricsEditor.createWidget());
        pages.addPage("SQL Workbench", this.sqlWorkbenchEditor.createWidget(this.presenter));
        pages.showPage(0);
        Widget pagesWidget = pages.asWidget();
        layout.add(pagesWidget, "Teiid");
        return layout;
    }

    Widget mainPageAsWidget() {
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.vdbProvider.getList());
        ToolStrip toolStrip = new ToolStrip();
        toolStrip.addToolButtonRight(new ToolButton(Console.CONSTANTS.common_label_refresh(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                VDBView.this.presenter.refresh(false);
            }
        }));
        DefaultCellTable table = new DefaultCellTable(5, (ProvidesKey)new ProvidesKey<VDB>(){

            public Object getKey(VDB item) {
                return item.getName() + "_" + item.getVersion();
            }
        });
        table.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        TextColumn<VDB> nameColumn = new TextColumn<VDB>(){

            public String getValue(VDB record) {
                return record.getName();
            }
        };
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new Comparator<VDB>(){

            @Override
            public int compare(VDB o1, VDB o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TextColumn<VDB> versionColumn = new TextColumn<VDB>(){

            public String getValue(VDB vdb) {
                return vdb.getVersion();
            }
        };
        versionColumn.setSortable(true);
        sortHandler.setComparator((Column)versionColumn, (Comparator)new Comparator<VDB>(){

            @Override
            public int compare(VDB o1, VDB o2) {
                return o1.getVersion().compareTo(o2.getVersion());
            }
        });
        TextColumn<VDB> dynamicColumn = new TextColumn<VDB>(){

            public String getValue(VDB record) {
                return String.valueOf(record.isDynamic());
            }
        };
        dynamicColumn.setSortable(true);
        sortHandler.setComparator((Column)dynamicColumn, (Comparator)new Comparator<VDB>(){

            @Override
            public int compare(VDB o1, VDB o2) {
                return o1.isDynamic().compareTo(o2.isDynamic());
            }
        });
        TextColumn<VDB> statusColumn = new TextColumn<VDB>(){

            public String getValue(VDB record) {
                return String.valueOf(record.getStatus());
            }
        };
        statusColumn.setSortable(true);
        sortHandler.setComparator((Column)statusColumn, (Comparator)new Comparator<VDB>(){

            @Override
            public int compare(VDB o1, VDB o2) {
                return o1.getStatus().compareTo(o2.getStatus());
            }
        });
        Column<VDB, ImageResource> validColumn = new Column<VDB, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(VDB vdb) {
                ImageResource res = null;
                res = vdb.isValid() != false ? Icons.INSTANCE.status_good() : TeiidIcons.INSTANCE.status_not_ok();
                return res;
            }
        };
        validColumn.setSortable(true);
        sortHandler.setComparator((Column)validColumn, (Comparator)new Comparator<VDB>(){

            @Override
            public int compare(VDB o1, VDB o2) {
                return o1.isValid().compareTo(o2.isValid());
            }
        });
        Column<VDB, String> reloadBtn = new Column<VDB, String>((Cell)new ButtonCell()){

            public String getValue(VDB record) {
                return "Reload";
            }
        };
        reloadBtn.setFieldUpdater((FieldUpdater)new FieldUpdater<VDB, String>(){

            public void update(int index, VDB vdb, String value) {
                VDBView.this.reloadVDB(vdb);
            }
        });
        table.addColumn((Column)nameColumn, "Name");
        table.addColumn((Column)versionColumn, "Version");
        table.addColumn((Column)dynamicColumn, "Dynamic");
        table.addColumn((Column)statusColumn, "Status");
        table.addColumn((Column)validColumn, "Valid");
        table.addColumn((Column)reloadBtn, "Reload");
        table.getColumnSortList().push((Column)nameColumn);
        this.vdbTable = table;
        this.vdbProvider.addDataDisplay((HasData)table);
        this.vdbRequestsTab = new VDBRequestsTab(this.presenter);
        this.vdbModelsTab = new VDBModelsTab(this.presenter);
        this.vdbModelsTab.setDataModelFactory(this.factory);
        this.vdbSessionsTab = new VDBSessionsTab(this.presenter);
        this.vdbCachingTab = new VDBCachingTab(this.presenter);
        MultipleToOneLayout layout = new MultipleToOneLayout().setPlain(true).setTitle("VDB Panel").setDescription(new SafeHtmlBuilder().appendHtmlConstant("").toSafeHtml()).setHeadline("Deployed Virtual Databases").setTopLevelTools((Widget)toolStrip).setMaster("Deployed VDBS", (CellTable)table).addDetail("Summary", (Widget)new VDBSummaryTab(this.presenter).getPanel(table)).addDetail("Models", (Widget)this.vdbModelsTab.getPanel(table)).addDetail("Overrides", (Widget)new VDBTranslatorsTab(this.presenter).getPanel(table)).addDetail("Caching", (Widget)this.vdbCachingTab.getPanel(table)).addDetail("Data Roles", (Widget)new VDBDataRolesTab(this.presenter).getPanel(table)).addDetail("Requests", (Widget)this.vdbRequestsTab.getPanel(table)).addDetail("Sessions", (Widget)this.vdbSessionsTab.getPanel(table));
        return layout.build();
    }

    static void onTableSectionChange(DefaultCellTable table, final TableSelectionCallback callback) {
        SingleSelectionModel selectionModel = (SingleSelectionModel)table.getSelectionModel();
        if (selectionModel == null) {
            throw new RuntimeException("Define selection model for table");
        }
        final SingleSelectionModel finalSelectionModel = selectionModel;
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Object selectedObject = finalSelectionModel.getSelectedObject();
                        if (selectedObject != null) {
                            callback.onSelectionChange(selectedObject);
                        } else {
                            callback.onSelectionChange(null);
                        }
                    }
                });
            }
        });
    }

    static DefaultCellTable<ValidityError> buildErrorTable() {
        ProvidesKey<ValidityError> keyProvider = new ProvidesKey<ValidityError>(){

            public Object getKey(ValidityError item) {
                return item.getMessage();
            }
        };
        DefaultCellTable errors = new DefaultCellTable(5, (ProvidesKey)keyProvider);
        TextColumn<ValidityError> modelPath = new TextColumn<ValidityError>(){

            public String getValue(ValidityError record) {
                return record.getPath();
            }
        };
        Column<ValidityError, String> errorMsg = new Column<ValidityError, String>((Cell)new TextAreaCell()){

            public String getValue(ValidityError record) {
                return record.getMessage();
            }
        };
        errors.setTitle("Validation Errors");
        errors.addColumn((Column)modelPath, "Path");
        errors.addColumn((Column)errorMsg, "Error/Warnings");
        errors.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        return errors;
    }

    static DefaultCellTable<ModelNode> buildSQLResultTable(List<ModelNode> list) {
        DefaultCellTable result = new DefaultCellTable(8);
        result.setTitle("SQL Result");
        Object[] attributes = list.get(0).keys().toArray();
        for (int i = 0; i < attributes.length; ++i) {
            final String name = attributes[i].toString();
            TextColumn<ModelNode> modelPath = new TextColumn<ModelNode>(){

                public String getValue(ModelNode record) {
                    return record.get(name).asString();
                }
            };
            result.addColumn((Column)modelPath, name);
        }
        return result;
    }

    static DefaultCellTable<KeyValuePair> buildPropertiesTable() {
        ProvidesKey<KeyValuePair> keyProvider = new ProvidesKey<KeyValuePair>(){

            public Object getKey(KeyValuePair item) {
                return item.getKey();
            }
        };
        DefaultCellTable propertiesTable = new DefaultCellTable(8, (ProvidesKey)keyProvider);
        TextColumn<KeyValuePair> nameColumn = new TextColumn<KeyValuePair>(){

            public String getValue(KeyValuePair record) {
                return record.getKey();
            }
        };
        TextColumn<KeyValuePair> valueColumn = new TextColumn<KeyValuePair>(){

            public String getValue(KeyValuePair record) {
                return record.getValue();
            }
        };
        propertiesTable.setTitle("Properties");
        propertiesTable.addColumn((Column)nameColumn, "Key");
        propertiesTable.addColumn((Column)valueColumn, "Value");
        propertiesTable.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        return propertiesTable;
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public void terminateSessionSubmitted(Session session) {
        this.vdbSessionsTab.terminateSubmitted(session);
    }

    @Override
    public void setVDBSessions(String vdbName, String version, List<Session> sessions) {
        this.vdbSessionsTab.setSessions(sessions);
    }

    @Override
    public <T> void setQueryResults(List<T> results, String sql, String clazz) {
        this.vdbCachingTab.setQueryResults(results, clazz);
        this.sqlWorkbenchEditor.setQueryResults(results, sql, clazz);
    }

    @Override
    public void connectionTypeChanged(String vdbName, String version) {
        this.presenter.refresh(false);
    }

    private void reloadVDB(VDB vdb) {
        this.presenter.reloadVDB(vdb.getName(), vdb.getVersion());
    }

    @Override
    public void vdbReloaded(String vdbName, String version) {
        this.presenter.refresh(false);
    }

    @Override
    public void setCacheStatistics(CacheStatistics cache) {
        this.vdbCachingTab.setCacheStatistics(cache);
    }

    @Override
    public void setSourceRequests(Request selection, List<Request> requests) {
        this.vdbRequestsTab.setSourceRequests(selection, requests);
    }

    @Override
    public void setEngineStatistics(EngineStatistics stats) {
        this.metricsEditor.setEngineStatistics(stats);
    }

    static interface TableSelectionCallback<T> {
        public void onSelectionChange(T var1);
    }

    static interface TabProvider {
        public VerticalPanel getPanel(DefaultCellTable var1);
    }
}

