/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.core.DisposableViewImpl;
import org.jboss.as.console.client.shared.runtime.Metric;
import org.jboss.as.console.client.shared.runtime.Sampler;
import org.jboss.as.console.client.shared.runtime.charts.Column;
import org.jboss.as.console.client.shared.runtime.charts.NumberColumn;
import org.jboss.as.console.client.shared.runtime.plain.PlainColumnView;
import org.jboss.as.console.client.shared.viewframework.builder.SimpleLayout;
import org.jboss.as.console.client.teiid.model.EngineStatistics;
import org.jboss.as.console.client.teiid.runtime.TeiidPresenter;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;

public class TeiidView
extends DisposableViewImpl
implements TeiidPresenter.MyView {
    private TeiidPresenter presenter;
    private Sampler sampler;

    @Override
    public void setPresenter(TeiidPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget createWidget() {
        ToolStrip toolStrip = new ToolStrip();
        toolStrip.addToolButtonRight(new ToolButton(Console.CONSTANTS.common_label_refresh(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TeiidView.this.presenter.getEngineStatistics();
            }
        }));
        NumberColumn sessionCount = new NumberColumn("session-count", "Session Count");
        NumberColumn memoryInuse = new NumberColumn("total-memory-inuse-kb", "Memory in Use(KB)");
        NumberColumn memoryInActivePlans = new NumberColumn("total-memory-inuse-active-plans-kb", "Memory Used By Active Plans(KB)");
        NumberColumn diskReadCount = new NumberColumn("buffermgr-disk-read-count", "Buffer Disk Reads");
        NumberColumn diskWriteCount = new NumberColumn("buffermgr-disk-write-count", "Buffer Disk Writes");
        NumberColumn cacheReadCount = new NumberColumn("buffermgr-cache-read-count", "Buffer Cache Reads");
        NumberColumn cacheWriteCount = new NumberColumn("buffermgr-cache-write-count", "Buffer Cache Writes");
        NumberColumn spaceUsed = new NumberColumn("buffermgr-diskspace-used-mb", "Disk Space In Use(MB)");
        NumberColumn activePlanCount = new NumberColumn("active-plans-count", "Active Plan Count");
        NumberColumn waitingPlanCount = new NumberColumn("waiting-plans-count", "Waiting Plan Count");
        Column[] cols = new Column[]{sessionCount, memoryInuse, memoryInActivePlans, diskReadCount, diskWriteCount, cacheReadCount, cacheWriteCount, spaceUsed, activePlanCount, waitingPlanCount};
        this.sampler = new PlainColumnView("", null).setColumns(cols).setWidth(100, Style.Unit.PCT);
        SimpleLayout layout = new SimpleLayout().setTitle("Teiid").setHeadline("Teiid Metrics").setTopLevelTools(toolStrip.asWidget()).setDescription("Metrics for teiid subsystem").addContent("Teiid Metrics", this.sampler.asWidget());
        return layout.build();
    }

    @Override
    public void setEngineStatistics(EngineStatistics stats) {
        Metric metric = new Metric(new long[]{stats.getSessionCount().intValue(), stats.getTotalMemoryInUse(), stats.getTotalMemoryInUseByActivePlans(), stats.getBufferManagerDiskReadCount(), stats.getBufferManagerDiskWriteCount(), stats.getBufferManagerCacheReadCount(), stats.getBufferManagerCacheWriteCount(), stats.getBufferManagerDiskUsed(), stats.getActivePlansCount().intValue(), stats.getWaitingPlansCount().intValue()});
        this.sampler.addSample(metric);
    }
}

