/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.core.DisposableViewImpl;
import org.jboss.as.console.client.shared.viewframework.builder.SimpleLayout;
import org.jboss.as.console.client.teiid.AuditPresenter;
import org.jboss.as.console.client.teiid.model.TeiidLogger;
import org.jboss.ballroom.client.widgets.common.DefaultButton;

public class AuditView
extends DisposableViewImpl
implements AuditPresenter.MyView {
    private static final String DEBUG = "DEBUG";
    private AuditPresenter presenter;
    final CheckBox auditBtn = new CheckBox("Enable Audit Logging");
    final CheckBox commandBtn = new CheckBox("Enable Command Logging");
    final CheckBox traceBtn = new CheckBox("Enable Trace Logging");

    @Override
    public void setPresenter(AuditPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget createWidget() {
        SimpleLayout layout = new SimpleLayout().setTitle("Audit Logging").setHeadline("Audit/Command Logging").setDescription("Turn On/Off Audit/Command Logging. By default file handler(s) will be added. Alternatively, add TEIID_COMMAND_LOG/TEIID_AUDIT_LOG handlers to override the default handlers").addContent("Audit/Command Logging for Teiid Subsystem", (Widget)this.createLogPanel());
        return layout.build();
    }

    private CaptionPanel createLogPanel() {
        CaptionPanel captionPanel = new CaptionPanel("Select Logging Type");
        DefaultButton applyBtn = new DefaultButton("Apply", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                AuditView.this.presenter.addOrRemoveLogger("org.teiid.AUDIT_LOG", AuditView.this.auditBtn.getValue());
                AuditView.this.presenter.addOrRemoveLogger("org.teiid.COMMAND_LOG", AuditView.this.commandBtn.getValue());
                AuditView.this.presenter.addOrRemoveLogger("org.teiid", AuditView.this.traceBtn.getValue());
            }
        });
        VerticalPanel selectionPanel = new VerticalPanel();
        selectionPanel.add((Widget)this.auditBtn);
        selectionPanel.add((Widget)this.commandBtn);
        selectionPanel.add((Widget)this.traceBtn);
        selectionPanel.add((Widget)applyBtn);
        selectionPanel.setCellHorizontalAlignment((Widget)this.auditBtn, HasHorizontalAlignment.ALIGN_LEFT);
        selectionPanel.setCellHorizontalAlignment((Widget)this.commandBtn, HasHorizontalAlignment.ALIGN_LEFT);
        selectionPanel.setCellHorizontalAlignment((Widget)this.traceBtn, HasHorizontalAlignment.ALIGN_LEFT);
        captionPanel.add((Widget)selectionPanel);
        captionPanel.setWidth("40%");
        captionPanel.getElement().setAttribute("style", "font-weight:bold;");
        return captionPanel;
    }

    @Override
    public void loggingStatus(String context, TeiidLogger logger) {
        if ("org.teiid.AUDIT_LOG".equals(context)) {
            if (logger != null && logger.getLevel().equals(DEBUG)) {
                this.auditBtn.setValue(Boolean.TRUE);
            } else {
                this.auditBtn.setValue(Boolean.FALSE);
            }
        }
        if ("org.teiid.COMMAND_LOG".equals(context)) {
            if (logger != null && logger.getLevel().equals(DEBUG)) {
                this.commandBtn.setValue(Boolean.TRUE);
            } else {
                this.commandBtn.setValue(Boolean.FALSE);
            }
        }
        if ("org.teiid".equals(context)) {
            if (logger != null && logger.getLevel().equals("TRACE")) {
                this.traceBtn.setValue(Boolean.TRUE);
            } else {
                this.traceBtn.setValue(Boolean.FALSE);
            }
        }
    }

    @Override
    public void initialLoad() {
        this.presenter.getLogger("org.teiid.AUDIT_LOG");
        this.presenter.getLogger("org.teiid.COMMAND_LOG");
        this.presenter.getLogger("org.teiid");
    }

    @Override
    public void logHandlerAdded(String handlerName, boolean added) {
        if (!added) {
            Console.info((String)("Addition Logging handler " + handlerName + " failed"));
        }
    }

    @Override
    public void logHandlerRemoved(String handlerName, boolean removed) {
        if (!removed) {
            Console.info((String)("Removal of Logging handler " + handlerName + " failed"));
        }
    }

    @Override
    public void loggerAdded(String context, boolean added) {
        if (!added) {
            Console.info((String)("Addition of Logger " + context + " failed"));
        }
    }

    @Override
    public void loggerRemoved(String context, boolean removed) {
        if (!removed) {
            Console.info((String)("Removal of Logger " + context + " failed"));
        }
    }

    @Override
    public void addLogger(String context) {
        if (context.equals("org.teiid.AUDIT_LOG")) {
            this.presenter.checkHandler(context, "TEIID_AUDIT_LOG", true);
        }
        if (context.equals("org.teiid.COMMAND_LOG")) {
            this.presenter.checkHandler(context, "TEIID_COMMAND_LOG", true);
        }
        if (context.equals("org.teiid")) {
            this.presenter.addLogger(context, "TRACE", null);
        }
    }

    @Override
    public void handlerExists(String context, String name, boolean dbAppender, boolean exists) {
        if (exists) {
            if (context.equals("org.teiid.AUDIT_LOG")) {
                this.presenter.addLogger(context, DEBUG, "TEIID_AUDIT_LOG");
            }
            if (context.equals("org.teiid.COMMAND_LOG")) {
                this.presenter.addLogger(context, DEBUG, "TEIID_COMMAND_LOG");
            }
        } else if (dbAppender) {
            if (context.equals("org.teiid.AUDIT_LOG")) {
                this.presenter.checkHandler(context, "TEIID_AUDIT_LOG", false);
            }
            if (context.equals("org.teiid.COMMAND_LOG")) {
                this.presenter.checkHandler(context, "TEIID_COMMAND_LOG", false);
            }
        } else {
            if (context.equals("org.teiid.AUDIT_LOG")) {
                this.presenter.addFileHandler("TEIID_AUDIT_LOG", "teiid-audit.log");
                this.presenter.addLogger(context, DEBUG, "TEIID_AUDIT_LOG");
            }
            if (context.equals("org.teiid.COMMAND_LOG")) {
                this.presenter.addFileHandler("TEIID_COMMAND_LOG", "teiid-command.log");
                this.presenter.addLogger(context, DEBUG, "TEIID_COMMAND_LOG");
            }
        }
    }

    @Override
    public void deleteLogger(String context) {
        if (context.equals("org.teiid.AUDIT_LOG")) {
            this.presenter.removeLogger(context);
        }
        if (context.equals("org.teiid.COMMAND_LOG")) {
            this.presenter.removeLogger(context);
        }
        if (context.equals("org.teiid")) {
            this.presenter.removeLogger(context);
        }
    }
}

