/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.Proxy;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.dispatch.Action;
import org.jboss.as.console.client.shared.dispatch.DispatchAsync;
import org.jboss.as.console.client.shared.dispatch.impl.DMRAction;
import org.jboss.as.console.client.shared.dispatch.impl.DMRResponse;
import org.jboss.as.console.client.shared.runtime.RuntimeBaseAddress;
import org.jboss.as.console.client.shared.state.ServerSelectionChanged;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.teiid.model.EngineStatistics;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.spi.RuntimeExtension;
import org.jboss.dmr.client.ModelNode;

public class TeiidPresenter
extends Presenter<MyView, MyProxy>
implements ServerSelectionChanged.ChangeListener {
    private DispatchAsync dispatcher;
    private RevealStrategy revealStrategy;
    private EntityAdapter<EngineStatistics> runtimeAdaptor;

    @Inject
    public TeiidPresenter(EventBus eventBus, MyView view, MyProxy proxy, DispatchAsync dispatcher, ApplicationMetaData metaData, RevealStrategy revealStrategy) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.dispatcher = dispatcher;
        this.revealStrategy = revealStrategy;
        this.runtimeAdaptor = new EntityAdapter(EngineStatistics.class, metaData);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
        this.getEventBus().addHandler((Event.Type)ServerSelectionChanged.TYPE, (Object)this);
    }

    public void onServerSelectionChanged(boolean isRunning) {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TeiidPresenter.this.getEngineStatistics();
            }
        });
    }

    protected void onReset() {
        super.onReset();
        if (this.isVisible()) {
            this.getEngineStatistics();
        }
    }

    protected void revealInParent() {
        this.revealStrategy.revealInRuntimeParent((Presenter)this);
    }

    public void getEngineStatistics() {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "teiid");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("engine-statistics");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (response.get("result").isDefined()) {
                    EngineStatistics stats = (EngineStatistics)TeiidPresenter.this.runtimeAdaptor.fromDMR(response.get("result"));
                    ((MyView)TeiidPresenter.this.getView()).setEngineStatistics(stats);
                } else {
                    ((MyView)TeiidPresenter.this.getView()).setEngineStatistics(null);
                }
            }
        });
    }

    public static interface MyView
    extends View {
        public void setPresenter(TeiidPresenter var1);

        public void setEngineStatistics(EngineStatistics var1);
    }

    @RuntimeExtension(name="Teiid", key="teiid")
    @ProxyCodeSplit
    @NameToken(value="teiid-runtime")
    public static interface MyProxy
    extends Proxy<TeiidPresenter>,
    Place {
    }
}

