/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.Proxy;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.runtime.RuntimeBaseAddress;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.teiid.model.TeiidLogger;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;

public class AuditPresenter
extends Presenter<MyView, MyProxy> {
    public static final String CTX_COMMANDLOGGING = "org.teiid.COMMAND_LOG";
    public static final String CTX_AUDITLOGGING = "org.teiid.AUDIT_LOG";
    public static final String CTX_TRACELOGGING = "org.teiid";
    private DispatchAsync dispatch;
    private RevealStrategy revealStrategy;
    private EntityAdapter<TeiidLogger> loggerAdaptor;

    @Inject
    public AuditPresenter(EventBus eventBus, MyView view, MyProxy proxy, DispatchAsync asyncDispatcher, ApplicationMetaData metaData, RevealStrategy revealStrategy) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.dispatch = asyncDispatcher;
        this.revealStrategy = revealStrategy;
        this.loggerAdaptor = new EntityAdapter(TeiidLogger.class, metaData);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
    }

    protected void onReset() {
        super.onReset();
        ((MyView)this.getView()).initialLoad();
    }

    protected void revealInParent() {
        this.revealStrategy.revealInParent((Presenter)this);
    }

    public void getLogger(final String context) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (AuditPresenter.this.isSucess(response)) {
                    if (response.get("result").isDefined()) {
                        TeiidLogger logger = (TeiidLogger)AuditPresenter.this.loggerAdaptor.fromDMR(response.get("result"));
                        ((MyView)AuditPresenter.this.getView()).loggingStatus(context, logger);
                    }
                } else {
                    ((MyView)AuditPresenter.this.getView()).loggingStatus(context, null);
                }
            }

            public void onFailure(Throwable caught) {
                ((MyView)AuditPresenter.this.getView()).loggingStatus(context, null);
            }
        });
    }

    public void checkHandler(final String context, final String name, final boolean dbAppender) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        if (dbAppender) {
            address.add("async-handler", name);
        } else {
            address.add("periodic-rotating-file-handler", name);
        }
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (AuditPresenter.this.isSucess(response)) {
                    ((MyView)AuditPresenter.this.getView()).handlerExists(context, name, dbAppender, true);
                }
            }

            public void onFailure(Throwable caught) {
                ((MyView)AuditPresenter.this.getView()).handlerExists(context, name, dbAppender, false);
            }
        });
    }

    public void addOrRemoveLogger(final String context, final boolean addOperation) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (AuditPresenter.this.isSucess(response)) {
                    if (response.get("result").isDefined() && !addOperation) {
                        ((MyView)AuditPresenter.this.getView()).deleteLogger(context);
                    }
                } else if (addOperation) {
                    ((MyView)AuditPresenter.this.getView()).addLogger(context);
                }
            }

            public void onFailure(Throwable caught) {
                if (addOperation) {
                    ((MyView)AuditPresenter.this.getView()).addLogger(context);
                }
            }
        });
    }

    public void addFileHandler(final String name, String fileName) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("periodic-rotating-file-handler", name);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("append").set(new ModelNode().set("true"));
        operation.get("autoflush").set(new ModelNode().set("true"));
        operation.get("level").set(new ModelNode().set("DEBUG"));
        operation.get("suffix").set(new ModelNode().set(".yyyy-MM-dd"));
        operation.get("formatter").set(new ModelNode().set("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %X{teiid-session} %s%E%n"));
        ModelNode file = new ModelNode();
        file.get("path").set(new ModelNode().set(fileName));
        file.get("relative-to").set(new ModelNode().set("jboss.server.log.dir"));
        operation.get("file").set(file);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)AuditPresenter.this.getView()).logHandlerAdded(name, AuditPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                ((MyView)AuditPresenter.this.getView()).logHandlerAdded(name, false);
            }
        });
    }

    private boolean isSucess(ModelNode response) {
        return response.hasDefined("outcome") && response.get("outcome").asString().equals("success");
    }

    public void removeFileHandler(final String name) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("periodic-rotating-file-handler", name);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").set(address);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)AuditPresenter.this.getView()).logHandlerRemoved(name, AuditPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public void addLogger(final String context, String level, String handler) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("level").set(new ModelNode().set(level));
        if (handler != null) {
            operation.get("handlers").add(new ModelNode().set(handler));
        }
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)AuditPresenter.this.getView()).loggerAdded(context, AuditPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                ((MyView)AuditPresenter.this.getView()).logHandlerAdded(context, false);
            }
        });
    }

    public void removeLogger(final String context) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").set(address);
        this.dispatch.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)AuditPresenter.this.getView()).loggerRemoved(context, AuditPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public static interface MyView
    extends View {
        public void setPresenter(AuditPresenter var1);

        public void initialLoad();

        public void addLogger(String var1);

        public void deleteLogger(String var1);

        public void loggingStatus(String var1, TeiidLogger var2);

        public void logHandlerAdded(String var1, boolean var2);

        public void logHandlerRemoved(String var1, boolean var2);

        public void loggerAdded(String var1, boolean var2);

        public void loggerRemoved(String var1, boolean var2);

        public void handlerExists(String var1, String var2, boolean var3, boolean var4);
    }

    @SubsystemExtension(name="Audit Log", group="Teiid", key="teiid")
    @ProxyCodeSplit
    @NameToken(value={"teiid-audit"})
    public static interface MyProxy
    extends Proxy<AuditPresenter>,
    Place {
    }
}

