package org.jboss.as.console.client.plugins;

import com.google.common.collect.HashMultimap;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Generated;

import static java.util.Arrays.asList;

/*
* WARNING! This class is generated. Do not modify.
*/
@Generated("org.jboss.hal.processors.NameTokenProcessor")
public class RequiredResourcesRegistryImpl implements RequiredResourcesRegistry {

    private final Set<String> tokens;
    private final HashMultimap<String, String> resources;
    private final HashMultimap<String, String> operations;
    private final Map<String, Boolean> recursive;

    public RequiredResourcesRegistryImpl() {
        tokens = new HashSet<>();
        resources = HashMultimap.create();
        operations = HashMultimap.create();
        recursive = new HashMap<>();

        tokens.add("host-vm");
        resources.putAll("host-vm", asList("/{implicit.host}/{selected.server}/core-service=platform-mbean/type=runtime", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=memory", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=threading"));
        recursive.put("host-vm", true);
        tokens.add("xads");
        resources.putAll("xads", asList("/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        recursive.put("xads", true);
        tokens.add("csp");
        recursive.put("csp", false);
        tokens.add("server-groups");
        resources.putAll("server-groups", asList("opt://server-group=*/system-property=*", "/server-group=*"));
        recursive.put("server-groups", false);
        tokens.add("webservices");
        resources.putAll("webservices", asList("{selected.profile}/subsystem=webservices"));
        recursive.put("webservices", true);
        tokens.add("domain-runtime");
        resources.putAll("domain-runtime", asList("/{implicit.host}/server-config=*"));
        recursive.put("domain-runtime", false);
        tokens.add("activemq-messaging");
        resources.putAll("activemq-messaging", asList("{selected.profile}/subsystem=messaging-activemq/server=*"));
        recursive.put("activemq-messaging", true);
        tokens.add("mail");
        resources.putAll("mail", asList("{selected.profile}/subsystem=mail/mail-session=*"));
        recursive.put("mail", true);
        tokens.add("servlet");
        resources.putAll("servlet", asList("{selected.profile}/subsystem=undertow/servlet-container=*/setting=websockets", "{selected.profile}/subsystem=undertow/servlet-container=*", "{selected.profile}/subsystem=undertow/servlet-container=*/setting=persistent-sessions", "{selected.profile}/subsystem=undertow/servlet-container=*/setting=session-cookie", "{selected.profile}/subsystem=undertow/servlet-container=*/setting=jsp"));
        recursive.put("servlet", true);
        tokens.add("main");
        recursive.put("main", false);
        tokens.add("host-interfaces");
        resources.putAll("host-interfaces", asList("/{selected.host}/interface=*"));
        recursive.put("host-interfaces", true);
        tokens.add("host-jvms");
        resources.putAll("host-jvms", asList("/{selected.host}/jvm=*"));
        recursive.put("host-jvms", true);
        tokens.add("path");
        resources.putAll("path", asList("path=*"));
        recursive.put("path", true);
        tokens.add("socket-bindings");
        resources.putAll("socket-bindings", asList("socket-binding-group=*"));
        recursive.put("socket-bindings", true);
        tokens.add("tx-metrics");
        resources.putAll("tx-metrics", asList("/{implicit.host}/{selected.server}/subsystem=transactions"));
        recursive.put("tx-metrics", true);
        tokens.add("deployment-scanner");
        resources.putAll("deployment-scanner", asList("{selected.profile}/subsystem=deployment-scanner/scanner=*", "{selected.profile}/subsystem=deployment-scanner"));
        recursive.put("deployment-scanner", true);
        tokens.add("jmx");
        resources.putAll("jmx", asList("{selected.profile}/subsystem=jmx"));
        recursive.put("jmx", false);
        tokens.add("messaging-cluster");
        resources.putAll("messaging-cluster", asList("{selected.profile}/subsystem=messaging/hornetq-server=*"));
        recursive.put("messaging-cluster", true);
        tokens.add("batch-jberet");
        resources.putAll("batch-jberet", asList("{selected.profile}/subsystem=batch-jberet"));
        recursive.put("batch-jberet", true);
        tokens.add("server-overview");
        recursive.put("server-overview", false);
        tokens.add("security_domain");
        resources.putAll("security_domain", asList("{selected.profile}/subsystem=security/security-domain=*/authentication=classic", "{selected.profile}/subsystem=security/security-domain=*/audit=classic", "{selected.profile}/subsystem=security/", "{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*", "{selected.profile}/subsystem=security/security-domain=*", "{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*", "{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*", "{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*", "{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*", "{selected.profile}/subsystem=security/security-domain=*/mapping=classic", "{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic", "{selected.profile}/subsystem=security/security-domain=*/acl=classic", "{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*", "{selected.profile}/subsystem=security/security-domain=*/authorization=classic"));
        recursive.put("security_domain", false);
        tokens.add("undertow-subsystem");
        resources.putAll("undertow-subsystem", asList("{selected.profile}/subsystem=undertow"));
        recursive.put("undertow-subsystem", true);
        tokens.add("tx-logs");
        resources.putAll("tx-logs", asList("/{implicit.host}/{selected.server}/subsystem=transactions/log-store=log-store"));
        operations.putAll("tx-logs", asList("/{implicit.host}/{selected.server}/subsystem=transactions/log-store=log-store#probe"));
        recursive.put("tx-logs", true);
        tokens.add("jpa-metrics");
        resources.putAll("jpa-metrics", asList("/{implicit.host}/{selected.server}/deployment=*/subsystem=jpa"));
        recursive.put("jpa-metrics", true);
        tokens.add("activemq-messaging-connections");
        resources.putAll("activemq-messaging-connections", asList("{selected.profile}/subsystem=messaging-activemq/jms-bridge=*", "{selected.profile}/subsystem=messaging-activemq/server=*"));
        recursive.put("activemq-messaging-connections", true);
        tokens.add("logviewer");
        resources.putAll("logviewer", asList("/{implicit.host}/{selected.server}/subsystem=logging"));
        recursive.put("logviewer", false);
        tokens.add("ee");
        resources.putAll("ee", asList("{selected.profile}/subsystem=ee/service=default-bindings", "{selected.profile}/subsystem=ee", "{selected.profile}/subsystem=ee/context-service=*", "{selected.profile}/subsystem=ee/managed-executor-service=*", "{selected.profile}/subsystem=ee/managed-scheduled-executor-service=*", "{selected.profile}/subsystem=ee/managed-thread-factory=*"));
        recursive.put("ee", true);
        tokens.add("settings");
        recursive.put("settings", false);
        tokens.add("standalone-deployments");
        resources.putAll("standalone-deployments", asList("/deployment=*"));
        recursive.put("standalone-deployments", false);
        tokens.add("hosts");
        resources.putAll("hosts", asList("opt://server-group=*/system-property=*", "/server-group=*"));
        recursive.put("hosts", false);
        tokens.add("topology");
        resources.putAll("topology", asList("/{implicit.host}/server-config=*", "/server-group=*"));
        recursive.put("topology", false);
        tokens.add("io");
        resources.putAll("io", asList("{selected.profile}/subsystem=io"));
        recursive.put("io", true);
        tokens.add("iiop-openjdk");
        resources.putAll("iiop-openjdk", asList("{selected.profile}/subsystem=iiop-openjdk"));
        recursive.put("iiop-openjdk", true);
        tokens.add("profile");
        recursive.put("profile", false);
        tokens.add("profiles");
        resources.putAll("profiles", asList("/profile=*"));
        recursive.put("profiles", false);
        tokens.add("batch");
        resources.putAll("batch", asList("{selected.profile}/subsystem=batch"));
        recursive.put("batch", true);
        tokens.add("cache-container");
        resources.putAll("cache-container", asList("{selected.profile}/subsystem=infinispan/cache-container=*/transport=jgroups", "{selected.profile}/subsystem=infinispan/cache-container=*", "{selected.profile}/subsystem=infinispan"));
        recursive.put("cache-container", false);
        tokens.add("batch-jberet-metrics");
        resources.putAll("batch-jberet-metrics", asList("{implicit.host}/{selected.server}/subsystem=batch-jberet"));
        recursive.put("batch-jberet-metrics", true);
        tokens.add("jgroups");
        resources.putAll("jgroups", asList("{selected.profile}/subsystem=jgroups"));
        recursive.put("jgroups", true);
        tokens.add("transactions");
        resources.putAll("transactions", asList("{selected.profile}/subsystem=transactions"));
        recursive.put("transactions", true);
        tokens.add("server-config");
        resources.putAll("server-config", asList("/{implicit.host}/server-config=*", "opt://{implicit.host}/server-config=*/system-property=*"));
        recursive.put("server-config", false);
        tokens.add("messaging-connections");
        resources.putAll("messaging-connections", asList("{selected.profile}/subsystem=messaging/jms-bridge=*", "{selected.profile}/subsystem=messaging/hornetq-server=*"));
        recursive.put("messaging-connections", true);
        tokens.add("messaging");
        resources.putAll("messaging", asList("{selected.profile}/subsystem=messaging/hornetq-server=*"));
        recursive.put("messaging", true);
        tokens.add("datasources");
        resources.putAll("datasources", asList("/{selected.profile}/subsystem=datasources/data-source=*"));
        recursive.put("datasources", true);
        tokens.add("naming");
        resources.putAll("naming", asList("/{implicit.host}/{selected.server}/subsystem=naming"));
        operations.putAll("naming", asList("/{implicit.host}/{selected.server}/subsystem=naming#jndi-view"));
        recursive.put("naming", false);
        tokens.add("vm");
        resources.putAll("vm", asList("/{implicit.host}/{selected.server}/core-service=platform-mbean/type=runtime", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=memory", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "/{implicit.host}/{selected.server}/core-service=platform-mbean/type=threading"));
        recursive.put("vm", true);
        tokens.add("activemq-messaging-cluster");
        resources.putAll("activemq-messaging-cluster", asList("{selected.profile}/subsystem=messaging-activemq/server=*"));
        recursive.put("activemq-messaging-cluster", true);
        tokens.add("logging");
        resources.putAll("logging", asList("{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*", "{selected.profile}/subsystem=logging/console-handler=*", "{selected.profile}/subsystem=logging/syslog-handler=*", "{selected.profile}/subsystem=logging/pattern-formatter=*", "{selected.profile}/subsystem=logging/custom-formatter=*", "{selected.profile}/subsystem=logging/root-logger=ROOT", "{selected.profile}/subsystem=logging/custom-handler=*", "{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*", "{selected.profile}/subsystem=logging/logger=*", "{selected.profile}/subsystem=logging/file-handler=*", "{selected.profile}/subsystem=logging/async-handler=*", "{selected.profile}/subsystem=logging/size-rotating-file-handler=*", "{selected.profile}/subsystem=logging"));
        recursive.put("logging", true);
        tokens.add("http");
        resources.putAll("http", asList("{selected.profile}/subsystem=undertow/server={undertow.server}/http-listener=*", "{selected.profile}/subsystem=undertow/server={undertow.server}/ajp-listener=*", "{selected.profile}/subsystem=undertow/server={undertow.server}", "{selected.profile}/subsystem=undertow/server={undertow.server}/host=*", "{selected.profile}/subsystem=undertow", "{selected.profile}/subsystem=undertow/server={undertow.server}/https-listener=*"));
        recursive.put("http", true);
        tokens.add("audit-log");
        resources.putAll("audit-log", asList("/{implicit.host}/core-service=management/access=audit"));
        recursive.put("audit-log", true);
        tokens.add("ds-finder");
        resources.putAll("ds-finder", asList("/{selected.profile}/subsystem=datasources/data-source=*", "/{selected.profile}/subsystem=datasources/xa-data-source=*"));
        recursive.put("ds-finder", true);
        tokens.add("web-metrics");
        resources.putAll("web-metrics", asList("/{implicit.host}/{selected.server}/subsystem=web"));
        recursive.put("web-metrics", false);
        tokens.add("jms-metrics");
        resources.putAll("jms-metrics", asList("/{implicit.host}/{selected.server}/subsystem=messaging/hornetq-server=*"));
        recursive.put("jms-metrics", true);
        tokens.add("caches");
        resources.putAll("caches", asList("{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=expiration", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=eviction", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/component=expiration", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=remote", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=remote", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/component=expiration", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=file", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=custom", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/component=locking", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=string-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=locking", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/component=transaction", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/component=eviction", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=file", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=file", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=custom", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=string-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=custom", "{selected.profile}/subsystem=infinispan/cache-container=*", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/component=eviction", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/component=transaction", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/component=locking", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/component=locking", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=string-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=file", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/store=string-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=custom", "{selected.profile}/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=transaction", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/store=remote", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/component=expiration", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=remote", "{selected.profile}/subsystem=infinispan/cache-container=*/replicated-cache=*/component=eviction", "{selected.profile}/subsystem=infinispan/cache-container=*/local-cache=*/component=transaction", "{selected.profile}/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc"));
        recursive.put("caches", true);
        tokens.add("undertow");
        recursive.put("undertow", false);
        tokens.add("jca");
        resources.putAll("jca", asList("{selected.profile}/subsystem=jca/cached-connection-manager=cached-connection-manager", "{selected.profile}/subsystem=jca/workmanager=*", "{selected.profile}/subsystem=jca/bean-validation=bean-validation", "{selected.profile}/subsystem=jca/bootstrap-context=*", "{selected.profile}/subsystem=jca/archive-validation=archive-validation", "{selected.profile}/subsystem=jca"));
        recursive.put("jca", true);
        tokens.add("ra-finder");
        resources.putAll("ra-finder", asList("{selected.profile}/subsystem=resource-adapters/resource-adapter=*"));
        recursive.put("ra-finder", true);
        tokens.add("no-server");
        recursive.put("no-server", false);
        tokens.add("login");
        recursive.put("login", false);
        tokens.add("patching");
        resources.putAll("patching", asList("/{implicit.host}", "/{implicit.host}/core-service=patching"));
        recursive.put("patching", false);
        tokens.add("tools");
        recursive.put("tools", false);
        tokens.add("host-properties");
        resources.putAll("host-properties", asList("/{selected.host}/system-property=*"));
        recursive.put("host-properties", true);
        tokens.add("hornetq");
        resources.putAll("hornetq", asList("{selected.profile}/subsystem=messaging/hornetq-server=*"));
        recursive.put("hornetq", false);
        tokens.add("web");
        resources.putAll("web", asList("/{selected.profile}/subsystem=web"));
        recursive.put("web", false);
        tokens.add("standalone-runtime");
        recursive.put("standalone-runtime", false);
        tokens.add("logfiles");
        resources.putAll("logfiles", asList("/{implicit.host}/{selected.server}/subsystem=logging"));
        recursive.put("logfiles", true);
        tokens.add("domain-deployments");
        resources.putAll("domain-deployments", asList("/deployment=*", "/server-group=*/deployment=*"));
        recursive.put("domain-deployments", false);
        tokens.add("ejb3");
        resources.putAll("ejb3", asList("{selected.profile}/subsystem=ejb3/cluster-passivation-store=*", "{selected.profile}/subsystem=ejb3/service=iiop", "{selected.profile}/subsystem=ejb3/service=remote", "{selected.profile}/subsystem=ejb3/service=async", "{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*", "{selected.profile}/subsystem=ejb3/thread-pool=*", "{selected.profile}/subsystem=ejb3/cache=*", "{selected.profile}/subsystem=ejb3", "{selected.profile}/subsystem=ejb3/file-passivation-store=*", "{selected.profile}/subsystem=ejb3/remoting-profile=*", "{selected.profile}/subsystem=ejb3/service=timer-service", "{selected.profile}/subsystem=ejb3/passivation-store=*"));
        recursive.put("ejb3", true);
        tokens.add("modcluster");
        resources.putAll("modcluster", asList("{selected.profile}/subsystem=modcluster"));
        recursive.put("modcluster", false);
        tokens.add("mbui");
        recursive.put("mbui", false);
        tokens.add("jpa");
        resources.putAll("jpa", asList("{selected.profile}/subsystem=jpa"));
        recursive.put("jpa", true);
        tokens.add("mail-sessions");
        resources.putAll("mail-sessions", asList("{selected.profile}/subsystem=mail/mail-session=*"));
        recursive.put("mail-sessions", true);
        tokens.add("webservice-runtime");
        resources.putAll("webservice-runtime", asList("/{implicit.host}/{selected.server}/deployment=*/subsystem=webservices"));
        recursive.put("webservice-runtime", true);
        tokens.add("activemq");
        resources.putAll("activemq", asList("{selected.profile}/subsystem=messaging-activemq/server=*"));
        recursive.put("activemq", false);
        tokens.add("interfaces");
        resources.putAll("interfaces", asList("interface=*"));
        recursive.put("interfaces", true);
        tokens.add("rbac");
        resources.putAll("rbac", asList("/core-service=management/access=authorization"));
        recursive.put("rbac", false);
        tokens.add("resource-adapters");
        resources.putAll("resource-adapters", asList("{selected.profile}/subsystem=resource-adapters/resource-adapter=*", "{selected.profile}/subsystem=resource-adapters/resource-adapter=*/config-properties=*", "{selected.profile}/subsystem=resource-adapters/resource-adapter=*/admin-objects=*", "{selected.profile}/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*"));
        recursive.put("resource-adapters", true);
        tokens.add("configadmin");
        resources.putAll("configadmin", asList("/{selected.profile}/subsystem=osgi"));
        recursive.put("configadmin", true);
        tokens.add("remoting");
        resources.putAll("remoting", asList("{selected.profile}/subsystem=remoting/http-connector=*", "{selected.profile}/subsystem=remoting/outbound-connection=*", "{selected.profile}/subsystem=remoting/remote-outbound-connection=*", "{selected.profile}/subsystem=remoting/configuration=endpoint", "{selected.profile}/subsystem=remoting/connector=*", "{selected.profile}/subsystem=remoting/local-outbound-connection=*"));
        recursive.put("remoting", true);
        tokens.add("security_domains");
        resources.putAll("security_domains", asList("{selected.profile}/subsystem=security/", "{selected.profile}/subsystem=security/security-domain=*"));
        recursive.put("security_domains", false);
        tokens.add("home");
        recursive.put("home", false);
        tokens.add("http-metrics");
        resources.putAll("http-metrics", asList("/{implicit.host}/{selected.server}/subsystem=undertow", "/{implicit.host}/{selected.server}/subsystem=undertow/server=*"));
        recursive.put("http-metrics", true);
        tokens.add("environment");
        resources.putAll("environment", asList("/{implicit.host}/{selected.server}/core-service=platform-mbean/type=runtime"));
        recursive.put("environment", true);
        tokens.add("mbui-workbench");
        recursive.put("mbui-workbench", false);
        tokens.add("properties");
        resources.putAll("properties", asList("system-property=*"));
        recursive.put("properties", true);
        tokens.add("ds-metrics");
        resources.putAll("ds-metrics", asList("/{implicit.host}/{selected.server}/subsystem=datasources/xa-data-source=*", "/{implicit.host}/{selected.server}/subsystem=datasources/data-source=*"));
        recursive.put("ds-metrics", true);
    }

    @Override
    public Set<String> getTokens() {
        return tokens;
    }

    @Override
    public Set<String> getResources(String token) {
        if (resources.containsKey(token)) {
            return resources.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }

    @Override
    public Set<String> getOperations(String token) {
        if (operations.containsKey(token)) {
            return operations.get(token);
        } else {
            return Collections.<String>emptySet();
        }
    }

    @Override
    public boolean isRecursive(String token) {
        if (recursive.containsKey(token)) {
            return recursive.get(token);
        } else {
            return false;
        }
    }
}
