/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.processor;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.gwtplatform.dispatch.annotation.GenDispatch;
import com.gwtplatform.dispatch.annotation.In;
import com.gwtplatform.dispatch.annotation.Out;
import com.gwtplatform.dispatch.annotation.helper.BuilderGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ClassGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ReflectionHelper;
import com.gwtplatform.dispatch.annotation.processor.GenProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"com.gwtplatform.dispatch.annotation.GenDispatch"})
public class GenDispatchProcessor
extends GenProcessor {
    private static final String RPC_DISPATCH_PACKAGE = "com.gwtplatform.dispatch.rpc.shared";

    @Override
    public void process(Element dispatchElement) {
        GenDispatch genDispatch = dispatchElement.getAnnotation(GenDispatch.class);
        this.generateAction(dispatchElement, genDispatch.isSecure(), genDispatch.serviceName(), genDispatch.extraActionInterfaces());
        this.generateResult(dispatchElement, genDispatch.extraResultInterfaces());
    }

    protected void generateAction(Element dispatchElement, boolean isSecure, String serviceName, String extraActionInterfaces) {
        GenerationHelper writer = null;
        try {
            ReflectionHelper reflection = new ReflectionHelper(this.getEnvironment(), (TypeElement)dispatchElement);
            String dispatchElementSimpleName = reflection.getSimpleClassName();
            String dispatchActionSimpleName = dispatchElementSimpleName + "Action";
            String dispatchActionClassName = reflection.getClassName() + "Action";
            this.printMessage("Generating '" + dispatchActionClassName + "' from '" + dispatchElementSimpleName + "'.");
            Writer sourceWriter = this.getEnvironment().getFiler().createSourceFile(dispatchActionClassName, dispatchElement).openWriter();
            writer = new BuilderGenerationHelper(sourceWriter);
            Collection<VariableElement> annotatedInFields = reflection.getInFields();
            Collection<VariableElement> allFields = reflection.filterConstantFields(reflection.getInFields());
            Collection<VariableElement> optionalFields = reflection.sortFields(In.class, reflection.getOptionalFields(In.class));
            Collection<VariableElement> requiredFields = reflection.filterConstantFields(reflection.getInFields());
            requiredFields.removeAll(optionalFields);
            writer.generatePackageDeclaration(reflection.getPackageName());
            writer.generateImports("com.gwtplatform.dispatch.rpc.shared.Action");
            String actionInterface = "Action<" + dispatchElementSimpleName + "Result>";
            ((ClassGenerationHelper)writer).generateClassHeader(dispatchActionSimpleName, null, reflection.getClassRepresenter().getModifiers(), actionInterface, extraActionInterfaces);
            writer.generateFieldDeclarations(annotatedInFields);
            if (!optionalFields.isEmpty()) {
                writer.setWhitespaces(2);
                ((BuilderGenerationHelper)writer).generateBuilderClass(dispatchActionSimpleName, requiredFields, optionalFields, new String[0]);
                writer.resetWhitespaces();
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchActionSimpleName, Modifier.PROTECTED);
                if (!requiredFields.isEmpty()) {
                    ((ClassGenerationHelper)writer).generateConstructorUsingFields(dispatchActionSimpleName, requiredFields, Modifier.PUBLIC);
                }
                ((BuilderGenerationHelper)writer).generateCustomBuilderConstructor(dispatchActionSimpleName, allFields);
            } else if (!requiredFields.isEmpty()) {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchActionSimpleName, Modifier.PROTECTED);
                ((ClassGenerationHelper)writer).generateConstructorUsingFields(dispatchActionSimpleName, requiredFields, Modifier.PUBLIC);
            } else {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchActionSimpleName, Modifier.PUBLIC);
            }
            this.generateServiceNameAccessor(writer, dispatchElementSimpleName, serviceName);
            this.generateIsSecuredMethod(writer, isSecure);
            ((ClassGenerationHelper)writer).generateFieldAccessors(annotatedInFields);
            ((ClassGenerationHelper)writer).generateEquals(dispatchActionSimpleName, annotatedInFields);
            ((ClassGenerationHelper)writer).generateHashCode(annotatedInFields);
            ((ClassGenerationHelper)writer).generateToString(dispatchActionSimpleName, annotatedInFields);
            writer.generateFooter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void generateResult(Element dispatchElement, String extraResultInterfaces) {
        GenerationHelper writer = null;
        try {
            ReflectionHelper reflection = new ReflectionHelper(this.getEnvironment(), (TypeElement)dispatchElement);
            String dispatchElementSimpleName = reflection.getSimpleClassName();
            String dispatchResultSimpleName = dispatchElementSimpleName + "Result";
            String dispatchResultClassName = reflection.getClassName() + "Result";
            this.printMessage("Generating '" + dispatchResultClassName + "' from '" + dispatchElementSimpleName + "'.");
            Writer sourceWriter = this.getEnvironment().getFiler().createSourceFile(dispatchResultClassName, dispatchElement).openWriter();
            writer = new BuilderGenerationHelper(sourceWriter);
            Collection<VariableElement> annotatedOutFields = reflection.getOutFields();
            Collection<VariableElement> allFields = reflection.filterConstantFields(reflection.getOutFields());
            Collection<VariableElement> optionalFields = reflection.sortFields(Out.class, reflection.getOptionalFields(Out.class));
            Collection<VariableElement> requiredFields = reflection.filterConstantFields(reflection.getOutFields());
            requiredFields.removeAll(optionalFields);
            writer.generatePackageDeclaration(reflection.getPackageName());
            writer.generateImports(reflection.hasOptionalFields() ? IsSerializable.class.getName() : null, null, "com.gwtplatform.dispatch.rpc.shared.Result");
            String resultInterface = "Result";
            ((ClassGenerationHelper)writer).generateClassHeader(dispatchResultSimpleName, null, reflection.getClassRepresenter().getModifiers(), resultInterface, extraResultInterfaces);
            writer.generateFieldDeclarations(annotatedOutFields);
            if (!optionalFields.isEmpty()) {
                writer.setWhitespaces(2);
                ((BuilderGenerationHelper)writer).generateBuilderClass(dispatchResultSimpleName, requiredFields, optionalFields, "IsSerializable");
                writer.resetWhitespaces();
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchResultSimpleName, Modifier.PROTECTED);
                if (!requiredFields.isEmpty()) {
                    ((ClassGenerationHelper)writer).generateConstructorUsingFields(dispatchResultSimpleName, requiredFields, Modifier.PUBLIC);
                }
                ((BuilderGenerationHelper)writer).generateCustomBuilderConstructor(dispatchResultSimpleName, allFields);
            } else if (!requiredFields.isEmpty()) {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchResultSimpleName, Modifier.PROTECTED);
                ((ClassGenerationHelper)writer).generateConstructorUsingFields(dispatchResultSimpleName, requiredFields, Modifier.PUBLIC);
            } else {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dispatchResultSimpleName, Modifier.PUBLIC);
            }
            ((ClassGenerationHelper)writer).generateFieldAccessors(annotatedOutFields);
            ((ClassGenerationHelper)writer).generateEquals(dispatchResultSimpleName, annotatedOutFields);
            ((ClassGenerationHelper)writer).generateHashCode(annotatedOutFields);
            ((ClassGenerationHelper)writer).generateToString(dispatchResultSimpleName, annotatedOutFields);
            writer.generateFooter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void generateIsSecuredMethod(GenerationHelper writer, boolean isSecure) {
        writer.println();
        writer.println("  @Override");
        writer.println("  public boolean isSecured() {");
        writer.println("    return " + isSecure + ";");
        writer.println("  }");
    }

    protected void generateServiceNameAccessor(GenerationHelper writer, String simpleClassName, String serviceName) {
        writer.println();
        writer.println("  @Override");
        writer.println("  public String getServiceName() {");
        if (serviceName.isEmpty()) {
            writer.println("    return Action.DEFAULT_SERVICE_NAME + \"{0}\";", simpleClassName);
        } else {
            writer.println("    return \"{0}\";", serviceName);
        }
        writer.println("  }");
    }
}

