/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.processor;

import com.gwtplatform.dispatch.annotation.helper.BuilderGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ClassGenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.GenerationHelper;
import com.gwtplatform.dispatch.annotation.helper.ReflectionHelper;
import com.gwtplatform.dispatch.annotation.processor.GenProcessor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"com.gwtplatform.dispatch.annotation.GenDto"})
public class GenDtoProcessor
extends GenProcessor {
    @Override
    public void process(Element dtoElement) {
        GenerationHelper writer = null;
        try {
            ReflectionHelper reflection = new ReflectionHelper(this.getEnvironment(), (TypeElement)dtoElement);
            String dtoElementSimpleName = reflection.getSimpleClassName();
            String dtoSimpleName = dtoElementSimpleName + "Dto";
            String dtoClassName = reflection.getClassName() + "Dto";
            this.printMessage("Generating '" + dtoClassName + "' from '" + dtoElementSimpleName + "'.");
            Writer sourceWriter = this.getEnvironment().getFiler().createSourceFile(dtoClassName, dtoElement).openWriter();
            writer = new BuilderGenerationHelper(sourceWriter);
            Collection<VariableElement> orderedElementFields = reflection.getOrderedFields();
            Collection<VariableElement> allFields = reflection.getNonConstantFields();
            Collection<VariableElement> optionalFields = reflection.getOptionalFields();
            Collection<VariableElement> requiredFields = reflection.getNonConstantFields();
            requiredFields.removeAll(optionalFields);
            writer.generatePackageDeclaration(reflection.getPackageName());
            writer.generateImports("com.google.gwt.user.client.rpc.IsSerializable");
            ((ClassGenerationHelper)writer).generateClassHeader(dtoSimpleName, null, reflection.getClassRepresenter().getModifiers(), "IsSerializable");
            writer.generateFieldDeclarations(orderedElementFields);
            if (!optionalFields.isEmpty()) {
                writer.setWhitespaces(2);
                ((BuilderGenerationHelper)writer).generateBuilderClass(dtoSimpleName, requiredFields, optionalFields, new String[0]);
                writer.resetWhitespaces();
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dtoSimpleName, Modifier.PROTECTED);
                if (!requiredFields.isEmpty()) {
                    ((ClassGenerationHelper)writer).generateConstructorUsingFields(dtoSimpleName, requiredFields, Modifier.PUBLIC);
                }
                ((BuilderGenerationHelper)writer).generateCustomBuilderConstructor(dtoSimpleName, allFields);
            } else if (!requiredFields.isEmpty()) {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dtoSimpleName, Modifier.PROTECTED);
                ((ClassGenerationHelper)writer).generateConstructorUsingFields(dtoSimpleName, requiredFields, Modifier.PUBLIC);
            } else {
                ((ClassGenerationHelper)writer).generateEmptyConstructor(dtoSimpleName, Modifier.PUBLIC);
            }
            ((ClassGenerationHelper)writer).generateFieldAccessors(orderedElementFields);
            ((ClassGenerationHelper)writer).generateEquals(dtoSimpleName, orderedElementFields);
            ((ClassGenerationHelper)writer).generateHashCode(orderedElementFields);
            ((ClassGenerationHelper)writer).generateToString(dtoSimpleName, orderedElementFields);
            writer.generateFooter();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

