/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.annotation.processor;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class GenProcessor
extends AbstractProcessor {
    private ProcessingEnvironment environment;

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        this.environment = environment;
    }

    public ProcessingEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.processingOver()) {
            this.onProcessingStarted();
            for (String supportedAnnotationName : this.getSupportedAnnotationTypes()) {
                this.printMessage("Searching for " + supportedAnnotationName + " annotations.");
                try {
                    Class<?> supportedAnnotationClass = Class.forName(supportedAnnotationName);
                    if (!supportedAnnotationClass.isAnnotation()) continue;
                    for (Element element : roundEnvironment.getElementsAnnotatedWith(supportedAnnotationClass)) {
                        this.printMessage("Found " + element.toString() + ".");
                        this.process(element);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.printError("Annotation not found: " + supportedAnnotationName);
                }
            }
            this.onProcessingCompleted();
        }
        return true;
    }

    public void printMessage(String message) {
        this.getEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    public void printError(String message) {
        this.getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    public abstract void process(Element var1);

    public void onProcessingStarted() {
        this.printMessage(this.getClass().getName() + " started.");
    }

    public void onProcessingCompleted() {
        this.printMessage(this.getClass().getName() + " finished.");
    }
}

